/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.dreamlu.mica.core.utils.Charsets;
import net.dreamlu.mica.core.utils.NumberUtil;
import net.dreamlu.mica.core.utils.ObjectUtil;
import net.dreamlu.mica.core.utils.RandomType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlUtils;

public final class StringUtil
extends StringUtils {
    private static final Pattern SPECIAL_CHARS_REGEX = Pattern.compile("[`'\"|/,;()-+*%#\u00b7\u2022\ufffd\u3000\\s]");
    private static final String INT_STR = "0123456789";
    private static final String STR_STR = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String ALL_STR = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    public static String firstCharToLower(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpper(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isBlank(@Nullable CharSequence cs) {
        return !StringUtil.hasText((CharSequence)cs);
    }

    public static boolean isNotBlank(@Nullable CharSequence cs) {
        return StringUtil.hasText((CharSequence)cs);
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        if (ObjectUtil.isEmpty((Object[])css)) {
            return true;
        }
        return Stream.of(css).anyMatch(StringUtil::isBlank);
    }

    public static boolean isNoneBlank(CharSequence ... css) {
        if (ObjectUtil.isEmpty((Object[])css)) {
            return false;
        }
        return Stream.of(css).allMatch(StringUtil::isNotBlank);
    }

    public static boolean isNumeric(CharSequence cs) {
        if (StringUtil.isBlank(cs)) {
            return false;
        }
        int i = cs.length();
        while (--i >= 0) {
            char chr = cs.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    public static String format(@Nullable String message, @Nullable Map<String, Object> params) {
        int end;
        int start;
        if (message == null) {
            return "";
        }
        if (params == null || params.isEmpty()) {
            return message;
        }
        StringBuilder sb = new StringBuilder((int)((double)message.length() * 1.5));
        int cursor = 0;
        while ((start = message.indexOf("${", cursor)) != -1 && (end = message.indexOf(125, start)) != -1) {
            sb.append(message, cursor, start);
            String key = message.substring(start + 2, end);
            Object value = params.get(StringUtil.trimWhitespace((String)key));
            sb.append(value == null ? "" : value);
            cursor = end + 1;
        }
        sb.append(message.substring(cursor));
        return sb.toString();
    }

    public static String format(@Nullable String message, Object ... arguments) {
        int end;
        int start;
        if (message == null) {
            return "";
        }
        if (arguments == null || arguments.length == 0) {
            return message;
        }
        StringBuilder sb = new StringBuilder((int)((double)message.length() * 1.5));
        int cursor = 0;
        int argsLength = arguments.length;
        for (int index = 0; (start = message.indexOf(123, cursor)) != -1 && (end = message.indexOf(125, start)) != -1 && index < argsLength; ++index) {
            sb.append(message, cursor, start);
            sb.append(arguments[index]);
            cursor = end + 1;
        }
        sb.append(message.substring(cursor));
        return sb.toString();
    }

    public static String join(Collection<?> coll) {
        return StringUtil.collectionToCommaDelimitedString(coll);
    }

    public static String join(Collection<?> coll, String delim) {
        return StringUtil.collectionToDelimitedString(coll, (String)delim);
    }

    public static String join(Object[] arr) {
        return StringUtil.arrayToCommaDelimitedString((Object[])arr);
    }

    public static String join(Object[] arr, String delim) {
        return StringUtil.arrayToDelimitedString((Object[])arr, (String)delim);
    }

    public static String[] split(@Nullable String str, @Nullable String delimiter) {
        return StringUtil.delimitedListToStringArray((String)str, (String)delimiter);
    }

    public static String[] splitTrim(@Nullable String str, @Nullable String delimiter) {
        return StringUtil.delimitedListToStringArray((String)str, (String)delimiter, (String)" \t\n\n\f");
    }

    public static boolean simpleMatch(@Nullable String pattern, @Nullable String str) {
        return PatternMatchUtils.simpleMatch((String)pattern, (String)str);
    }

    public static boolean simpleMatch(@Nullable String[] patterns, String str) {
        return PatternMatchUtils.simpleMatch((String[])patterns, (String)str);
    }

    public static String getUUID() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long lsb = random.nextLong();
        long msb = random.nextLong();
        byte[] buf = new byte[32];
        StringUtil.formatUnsignedLong(lsb, buf, 20, 12);
        StringUtil.formatUnsignedLong(lsb >>> 48, buf, 16, 4);
        StringUtil.formatUnsignedLong(msb, buf, 12, 4);
        StringUtil.formatUnsignedLong(msb >>> 16, buf, 8, 4);
        StringUtil.formatUnsignedLong(msb >>> 32, buf, 0, 8);
        return new String(buf, Charsets.UTF_8);
    }

    private static void formatUnsignedLong(long val, byte[] buf, int offset, int len) {
        int charPos = offset + len;
        int radix = 16;
        int mask = radix - 1;
        do {
            buf[--charPos] = NumberUtil.DIGITS[(int)val & mask];
            val >>>= 4;
        } while (charPos > offset);
    }

    public static String escapeHtml(String html) {
        return HtmlUtils.htmlEscape((String)html);
    }

    @Nullable
    public static String cleanText(@Nullable String txt) {
        if (txt == null) {
            return null;
        }
        return SPECIAL_CHARS_REGEX.matcher(txt).replaceAll("");
    }

    @Nullable
    public static String cleanIdentifier(@Nullable String param) {
        if (param == null) {
            return null;
        }
        StringBuilder paramBuilder = new StringBuilder();
        for (int i = 0; i < param.length(); ++i) {
            char c = param.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) continue;
            paramBuilder.append(c);
        }
        return paramBuilder.toString();
    }

    public static String random(int count) {
        return StringUtil.random(count, RandomType.ALL);
    }

    public static String random(int count, RandomType randomType) {
        if (count == 0) {
            return "";
        }
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)("Requested random string length " + count + " is less than 0."));
        ThreadLocalRandom random = ThreadLocalRandom.current();
        char[] buffer = new char[count];
        for (int i = 0; i < count; ++i) {
            buffer[i] = RandomType.INT == randomType ? INT_STR.charAt(random.nextInt(INT_STR.length())) : (RandomType.STRING == randomType ? STR_STR.charAt(random.nextInt(STR_STR.length())) : ALL_STR.charAt(random.nextInt(ALL_STR.length())));
        }
        return new String(buffer);
    }

    private StringUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

