/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import net.dreamlu.mica.core.utils.StringUtil;
import org.springframework.lang.Nullable;

public class SystemUtil {
    private static final String OS_NAME_LINUX = "LINUX";
    @Nullable
    public static final String USER_HOME = SystemUtil.getSystemProperty("user.home");
    @Nullable
    public static final String USER_DIR = SystemUtil.getSystemProperty("user.dir");
    @Nullable
    public static final String USER_NAME = SystemUtil.getSystemProperty("user.name");
    @Nullable
    public static final String OS_NAME = SystemUtil.getSystemProperty("os.name");

    @Nullable
    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    public static boolean isLinux() {
        return StringUtil.isNotBlank(OS_NAME) && OS_NAME_LINUX.equals(OS_NAME.toUpperCase());
    }

    public static boolean isLocalDev() {
        return !SystemUtil.isLinux();
    }
}

