/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Optional;
import java.util.function.Predicate;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.dreamlu.mica.core.utils.Charsets;
import net.dreamlu.mica.core.utils.ClassUtil;
import net.dreamlu.mica.core.utils.JsonUtil;
import net.dreamlu.mica.core.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.util.WebUtils;

public final class WebUtil
extends WebUtils {
    private static final Logger log = LoggerFactory.getLogger(WebUtil.class);
    private static final String[] IP_HEADER_NAMES = new String[]{"x-forwarded-for", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
    private static final Predicate<String> IS_BLANK_IP = ip -> StringUtil.isBlank(ip) || "unknown".equalsIgnoreCase((String)ip);

    public static boolean isBody(HandlerMethod handlerMethod) {
        ResponseBody responseBody = ClassUtil.getAnnotation(handlerMethod, ResponseBody.class);
        return responseBody != null;
    }

    @Nullable
    public static String getCookieVal(String name) {
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return null;
        }
        return WebUtil.getCookieVal(request, name);
    }

    @Nullable
    public static String getCookieVal(HttpServletRequest request, String name) {
        Cookie cookie = WebUtil.getCookie((HttpServletRequest)request, (String)name);
        return cookie != null ? cookie.getValue() : null;
    }

    public static void removeCookie(HttpServletResponse response, String key) {
        WebUtil.setCookie(response, key, null, 0);
    }

    public static void setCookie(HttpServletResponse response, String name, @Nullable String value, int maxAgeInSeconds) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }

    @Nullable
    public static HttpServletRequest getRequest() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(x -> (ServletRequestAttributes)x).map(ServletRequestAttributes::getRequest).orElse(null);
    }

    @Nullable
    public static HttpServletResponse getResponse() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(x -> (ServletRequestAttributes)x).map(ServletRequestAttributes::getResponse).orElse(null);
    }

    @Nullable
    public static String getIP() {
        return Optional.ofNullable(WebUtil.getRequest()).map(WebUtil::getIP).orElse(null);
    }

    @Nullable
    public static String getIP(@Nullable HttpServletRequest request) {
        String ipHeader;
        if (request == null) {
            return null;
        }
        String ip = null;
        String[] stringArray = IP_HEADER_NAMES;
        int n = stringArray.length;
        for (int i = 0; i < n && IS_BLANK_IP.test(ip = request.getHeader(ipHeader = stringArray[i])); ++i) {
        }
        if (IS_BLANK_IP.test(ip)) {
            ip = request.getRemoteAddr();
        }
        return StringUtil.isBlank(ip) ? null : StringUtil.splitTrim(ip, ",")[0];
    }

    public static void renderJson(HttpServletResponse response, @Nullable Object result) {
        String jsonText = JsonUtil.toJson(result);
        if (jsonText != null) {
            WebUtil.renderText(response, jsonText, "application/json");
        }
    }

    public static void renderJson(HttpServletResponse response, @Nullable String jsonText) {
        if (jsonText != null) {
            WebUtil.renderText(response, jsonText, "application/json");
        }
    }

    public static void renderText(HttpServletResponse response, String text, String contentType) {
        response.setCharacterEncoding(Charsets.UTF_8_NAME);
        response.setContentType(contentType);
        try (PrintWriter out = response.getWriter();){
            out.append(text);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private WebUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

