/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import net.dreamlu.mica.core.utils.Exceptions;
import org.springframework.util.StringUtils;

public final class INetUtil {
    public static final String LOCAL_HOST = "127.0.0.1";

    public static String getHostName() {
        String hostname;
        try {
            InetAddress address = InetAddress.getLocalHost();
            hostname = address.getHostName();
            if (!StringUtils.hasText((String)hostname)) {
                hostname = address.toString();
            }
        }
        catch (UnknownHostException ignore) {
            hostname = LOCAL_HOST;
        }
        return hostname;
    }

    public static String getHostIp() {
        String hostAddress;
        try {
            InetAddress address = INetUtil.getLocalHostLanAddress();
            hostAddress = address.getHostAddress();
            if (!StringUtils.hasText((String)hostAddress)) {
                hostAddress = address.toString();
            }
        }
        catch (UnknownHostException ignore) {
            hostAddress = LOCAL_HOST;
        }
        return hostAddress;
    }

    private static InetAddress getLocalHostLanAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> iFaces = NetworkInterface.getNetworkInterfaces();
            while (iFaces.hasMoreElements()) {
                NetworkInterface iFace = iFaces.nextElement();
                Enumeration<InetAddress> inetAdders = iFace.getInetAddresses();
                while (inetAdders.hasMoreElements()) {
                    InetAddress inetAddr = inetAdders.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean tryPort(int port) {
        try (ServerSocket ignore = new ServerSocket(port);){
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static InetAddress getInetAddress(String ip) {
        try {
            return InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static boolean isInternalIp(String ip) {
        return INetUtil.isInternalIp(INetUtil.getInetAddress(ip));
    }

    public static boolean isInternalIp(InetAddress address) {
        if (INetUtil.isLocalIp(address)) {
            return true;
        }
        return INetUtil.isInternalIp(address.getAddress());
    }

    public static boolean isLocalIp(InetAddress address) {
        return address.isAnyLocalAddress() || address.isLoopbackAddress() || address.isSiteLocalAddress();
    }

    public static boolean isInternalIp(byte[] addr) {
        byte b0 = addr[0];
        byte b1 = addr[1];
        int section1 = 10;
        int section2 = -84;
        int section3 = 16;
        int section4 = 31;
        int section5 = -64;
        int section6 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                if (b1 != -88) break;
                return true;
            }
        }
        return false;
    }

    private INetUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

