/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.log;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import net.dreamlu.mica.core.utils.Charsets;
import net.dreamlu.mica.core.utils.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogPrintStream
extends PrintStream {
    private static final Logger log = LoggerFactory.getLogger(LogPrintStream.class);
    private final boolean error;

    private LogPrintStream(boolean error) throws UnsupportedEncodingException {
        super((OutputStream)(error ? System.err : System.out), false, Charsets.UTF_8_NAME);
        this.error = error;
    }

    public static LogPrintStream log(boolean isError) {
        try {
            return new LogPrintStream(isError);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Override
    public void print(String s) {
        if (this.error) {
            log.error(s);
        } else {
            log.info(s);
        }
    }

    @Override
    public void println() {
    }

    @Override
    public void println(String x) {
        if (this.error) {
            log.error(x);
        } else {
            log.info(x);
        }
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        if (this.error) {
            log.error(String.format(format, args));
        } else {
            log.info(String.format(format, args));
        }
        return this;
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        if (this.error) {
            log.error(String.format(l, format, args));
        } else {
            log.info(String.format(l, format, args));
        }
        return this;
    }
}

