/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.tuple;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Pair<L, R> {
    private static final Pair<Object, Object> EMPTY = new Pair<Object, Object>(null, null);
    private final L left;
    private final R right;

    public static <L, R> Pair<L, R> empty() {
        return EMPTY;
    }

    public static <L, R> Pair<L, R> createLeft(L left) {
        if (left == null) {
            return Pair.empty();
        }
        return new Pair<L, Object>(left, null);
    }

    public static <L, R> Pair<L, R> createRight(R right) {
        if (right == null) {
            return Pair.empty();
        }
        return new Pair<Object, R>(null, right);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public static <L, R> Pair<L, R> create(@JsonProperty(value="left") L left, @JsonProperty(value="right") R right) {
        if (right == null && left == null) {
            return Pair.empty();
        }
        return new Pair<L, R>(left, right);
    }

    private Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public String toString() {
        return "Pair(left=" + this.getLeft() + ", right=" + this.getRight() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        if (!other.canEqual(this)) {
            return false;
        }
        L this$left = this.getLeft();
        L other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        R this$right = this.getRight();
        R other$right = other.getRight();
        return !(this$right == null ? other$right != null : !this$right.equals(other$right));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pair;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        L $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        R $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        return result;
    }
}

