/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import net.dreamlu.mica.core.utils.Charsets;
import org.springframework.lang.Nullable;
import org.springframework.web.util.UriUtils;

public final class PathUtil {
    @Nullable
    public static String getJarPath() {
        try {
            URL url = PathUtil.class.getResource("/").toURI().toURL();
            return PathUtil.toFilePath(url);
        }
        catch (Exception e) {
            String path = PathUtil.class.getResource("").getPath();
            return new File(path).getParentFile().getParentFile().getAbsolutePath();
        }
    }

    @Nullable
    private static String toFilePath(@Nullable URL url) {
        if (url == null) {
            return null;
        }
        String protocol = url.getProtocol();
        String file = UriUtils.decode((String)url.getPath(), (Charset)Charsets.UTF_8);
        if ("file".equals(protocol)) {
            return new File(file).getParentFile().getParentFile().getAbsolutePath();
        }
        if ("jar".equals(protocol) || "zip".equals(protocol)) {
            int ipos = file.indexOf("!/");
            if (ipos > 0) {
                file = file.substring(0, ipos);
            }
            if (file.startsWith("file:")) {
                file = file.substring("file:".length());
            }
            return new File(file).getParentFile().getAbsolutePath();
        }
        return file;
    }

    private PathUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

