/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.validation.constraintvalidators;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.dreamlu.mica.core.utils.CollectionUtil;
import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.core.validation.constraints.RangeIn;

public class RangeInValidator
implements ConstraintValidator<RangeIn, Object> {
    private RangeIn rangeIn;

    public void initialize(RangeIn constraintAnnotation) {
        this.rangeIn = constraintAnnotation;
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        String[] ranges = StringUtil.splitTrim(this.rangeIn.value(), ",");
        if (value instanceof CharSequence) {
            return CollectionUtil.contains(ranges, (CharSequence)value);
        }
        if (value instanceof Number) {
            return CollectionUtil.contains(ranges, value.toString());
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().allMatch(it -> CollectionUtil.contains(ranges, it.toString()));
        }
        if (value instanceof Iterable) {
            AtomicBoolean flag = new AtomicBoolean(true);
            ((Iterable)value).forEach(it -> {
                if (!CollectionUtil.contains(ranges, it.toString())) {
                    flag.set(false);
                }
            });
            return flag.get();
        }
        if (value instanceof Object[]) {
            return Arrays.stream((Object[])value).allMatch(it -> CollectionUtil.contains(ranges, it.toString()));
        }
        return false;
    }
}

