/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.dreamlu.mica.core.utils.Holder;
import net.dreamlu.mica.core.utils.NumberUtil;
import net.dreamlu.mica.core.utils.RandomType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlUtils;

public class StringUtil
extends StringUtils {
    private static final Pattern SPECIAL_CHARS_REGEX = Pattern.compile("[`'\"|/,;()-+*%#\u00b7\u2022\ufffd\u3000\\s]");
    private static final int PAD_LIMIT = 8192;

    public static String firstCharToLower(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpper(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isBlank(@Nullable CharSequence cs) {
        return !StringUtils.hasText((CharSequence)cs);
    }

    public static boolean isNotBlank(@Nullable CharSequence cs) {
        return StringUtils.hasText((CharSequence)cs);
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        if (ObjectUtils.isEmpty((Object[])css)) {
            return true;
        }
        return Stream.of(css).anyMatch(StringUtil::isBlank);
    }

    public static boolean isAnyBlank(Collection<CharSequence> css) {
        if (CollectionUtils.isEmpty(css)) {
            return true;
        }
        return css.stream().anyMatch(StringUtil::isBlank);
    }

    public static boolean isNoneBlank(CharSequence ... css) {
        if (ObjectUtils.isEmpty((Object[])css)) {
            return false;
        }
        return Stream.of(css).allMatch(StringUtil::isNotBlank);
    }

    public static boolean isNoneBlank(Collection<CharSequence> css) {
        if (CollectionUtils.isEmpty(css)) {
            return false;
        }
        return css.stream().allMatch(StringUtil::isNotBlank);
    }

    public static boolean isAnyNotBlank(CharSequence ... css) {
        if (ObjectUtils.isEmpty((Object[])css)) {
            return false;
        }
        return Stream.of(css).anyMatch(StringUtil::isNotBlank);
    }

    public static boolean isAnyNotBlank(Collection<CharSequence> css) {
        if (CollectionUtils.isEmpty(css)) {
            return false;
        }
        return css.stream().anyMatch(StringUtil::isNotBlank);
    }

    public static boolean isNumeric(CharSequence cs) {
        if (StringUtil.isBlank(cs)) {
            return false;
        }
        int i = cs.length();
        while (--i >= 0) {
            char chr = cs.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean startWith(CharSequence cs, char c) {
        return cs.charAt(0) == c;
    }

    public static boolean endWith(CharSequence cs, char c) {
        return cs.charAt(cs.length() - 1) == c;
    }

    public static String format(@Nullable String message, @Nullable Map<String, ?> params) {
        int end;
        int start;
        if (message == null) {
            return "";
        }
        if (params == null || params.isEmpty()) {
            return message;
        }
        StringBuilder sb = new StringBuilder((int)((double)message.length() * 1.5));
        int cursor = 0;
        while ((start = message.indexOf("${", cursor)) != -1 && (end = message.indexOf(125, start)) != -1) {
            sb.append(message, cursor, start);
            String key = message.substring(start + 2, end);
            Object value = params.get(StringUtils.trimWhitespace((String)key));
            sb.append((Object)(value == null ? "" : value));
            cursor = end + 1;
        }
        sb.append(message.substring(cursor));
        return sb.toString();
    }

    public static String format(@Nullable String message, Object ... arguments) {
        int end;
        int start;
        if (message == null) {
            return "";
        }
        if (arguments == null || arguments.length == 0) {
            return message;
        }
        StringBuilder sb = new StringBuilder((int)((double)message.length() * 1.5));
        int cursor = 0;
        int argsLength = arguments.length;
        for (int index = 0; (start = message.indexOf(123, cursor)) != -1 && (end = message.indexOf(125, start)) != -1 && index < argsLength; ++index) {
            sb.append(message, cursor, start);
            sb.append(arguments[index]);
            cursor = end + 1;
        }
        sb.append(message.substring(cursor));
        return sb.toString();
    }

    public static String format(long nanos) {
        if (nanos < 1L) {
            return "0ms";
        }
        double millis = (double)nanos / 1000000.0;
        if (millis > 1000.0) {
            return String.format("%.3fs", millis / 1000.0);
        }
        return String.format("%.3fms", millis);
    }

    public static String join(Collection<?> coll) {
        return StringUtils.collectionToCommaDelimitedString(coll);
    }

    public static String join(Collection<?> coll, String delim) {
        return StringUtils.collectionToDelimitedString(coll, (String)delim);
    }

    public static String join(Object[] arr) {
        return StringUtils.arrayToCommaDelimitedString((Object[])arr);
    }

    public static String join(Object[] arr, String delim) {
        return StringUtils.arrayToDelimitedString((Object[])arr, (String)delim);
    }

    public static String[] split(@Nullable String str, @Nullable String delimiter) {
        return StringUtils.delimitedListToStringArray((String)str, (String)delimiter);
    }

    public static String[] splitTrim(@Nullable String str, @Nullable String delimiter) {
        return StringUtils.delimitedListToStringArray((String)str, (String)delimiter, (String)" \t\n\n\f");
    }

    public static boolean simpleMatch(@Nullable String pattern, @Nullable String str) {
        return PatternMatchUtils.simpleMatch((String)pattern, (String)str);
    }

    public static boolean simpleMatch(@Nullable String[] patterns, String str) {
        return PatternMatchUtils.simpleMatch((String[])patterns, (String)str);
    }

    public static String getUUID() {
        return StringUtil.getId(ThreadLocalRandom.current(), 32, 16);
    }

    public static String getSafeUUID() {
        long lsb = Holder.SECURE_RANDOM.nextLong();
        long msb = Holder.SECURE_RANDOM.nextLong();
        byte[] buf = new byte[32];
        int radix = 16;
        StringUtil.formatUnsignedLong(lsb, radix, buf, 20, 12);
        StringUtil.formatUnsignedLong(lsb >>> 48, radix, buf, 16, 4);
        StringUtil.formatUnsignedLong(msb, radix, buf, 12, 4);
        StringUtil.formatUnsignedLong(msb >>> 16, radix, buf, 8, 4);
        StringUtil.formatUnsignedLong(msb >>> 32, radix, buf, 0, 8);
        return new String(buf, StandardCharsets.ISO_8859_1);
    }

    private static void formatUnsignedLong(long val, int radix, byte[] buf, int offset, int len) {
        int charPos = offset + len;
        int mask = radix - 1;
        do {
            buf[--charPos] = NumberUtil.DIGITS[(int)val & mask];
            val >>>= 4;
        } while (charPos > offset);
    }

    public static String getNanoId() {
        return StringUtil.getNanoId(ThreadLocalRandom.current(), true);
    }

    public static String getNanoId62() {
        return StringUtil.getNanoId(ThreadLocalRandom.current(), false);
    }

    public static String getSafeNanoId() {
        return StringUtil.getNanoId(Holder.SECURE_RANDOM, true);
    }

    public static String getSafeNanoId62() {
        return StringUtil.getNanoId(Holder.SECURE_RANDOM, false);
    }

    private static String getNanoId(Random random, boolean radix64) {
        return StringUtil.getId(random, 21, radix64 ? 64 : 62);
    }

    public static String getFastId(int len) {
        return StringUtil.getId(ThreadLocalRandom.current(), len, 62);
    }

    public static String getSafeId(int len) {
        return StringUtil.getId(Holder.SECURE_RANDOM, len, 62);
    }

    public static String getId(Random random, int len) {
        return StringUtil.getId(random, len, 62);
    }

    public static String getId(Random random, int len, int radix) {
        if (len < 8) {
            throw new IllegalArgumentException("\u4e3a\u4e86\u51cf\u5c11\u51b2\u7a81\uff0clen \u9700\u8981\u5927\u4e8e7\uff0c\u5b9e\u9645\u5c3d\u91cf\u8bbe\u7f6e\u572810~16\u6216\u4ee5\u4e0a\u3002");
        }
        byte[] randomBytes = new byte[len];
        random.nextBytes(randomBytes);
        int mask = radix - 1;
        for (int i = 0; i < len; ++i) {
            randomBytes[i] = NumberUtil.DIGITS[randomBytes[i] & 0xFF & mask];
        }
        return new String(randomBytes, StandardCharsets.ISO_8859_1);
    }

    public static String escapeHtml(String html) {
        return HtmlUtils.htmlEscape((String)html);
    }

    @Nullable
    public static String cleanText(@Nullable String txt) {
        if (txt == null) {
            return null;
        }
        return SPECIAL_CHARS_REGEX.matcher(txt).replaceAll("");
    }

    @Nullable
    public static String cleanIdentifier(@Nullable String param) {
        if (param == null) {
            return null;
        }
        StringBuilder paramBuilder = new StringBuilder();
        for (int i = 0; i < param.length(); ++i) {
            char c = param.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) continue;
            paramBuilder.append(c);
        }
        return paramBuilder.toString();
    }

    public static String random(int count) {
        return StringUtil.random(count, RandomType.ALL);
    }

    public static String random(int count, RandomType randomType) {
        if (count == 0) {
            return "";
        }
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)("Requested random string length " + count + " is less than 0."));
        SecureRandom random = Holder.SECURE_RANDOM;
        byte[] buffer = new byte[count];
        for (int i = 0; i < count; ++i) {
            buffer[i] = randomType.random(random);
        }
        return new String(buffer, StandardCharsets.ISO_8859_1);
    }

    public static String repeat(char ch, int repeat) {
        if (repeat <= 0) {
            return "";
        }
        char[] buf = new char[repeat];
        Arrays.fill(buf, ch);
        return new String(buf);
    }

    @Nullable
    public static String left(@Nullable String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    @Nullable
    public static String right(@Nullable String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return "";
        }
        int length = str.length();
        if (length <= len) {
            return str;
        }
        return str.substring(length - len);
    }

    @Nullable
    public static String rightPad(@Nullable String str, int size) {
        return StringUtil.rightPad(str, size, ' ');
    }

    @Nullable
    public static String rightPad(@Nullable String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtil.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(StringUtil.repeat(padChar, pads));
    }

    @Nullable
    public static String rightPad(@Nullable String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (!StringUtils.hasLength((String)padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtil.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    @Nullable
    public static String leftPad(@Nullable String str, int size) {
        return StringUtil.leftPad(str, size, ' ');
    }

    @Nullable
    public static String leftPad(@Nullable String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtil.leftPad(str, size, String.valueOf(padChar));
        }
        return StringUtil.repeat(padChar, pads).concat(str);
    }

    @Nullable
    public static String leftPad(@Nullable String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (!StringUtils.hasLength((String)padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtil.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    @Nullable
    public static String mid(@Nullable String str, int pos, int len) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (len < 0 || pos > length) {
            return "";
        }
        if (pos < 0) {
            pos = 0;
        }
        if (length <= pos + len) {
            return str.substring(pos);
        }
        return str.substring(pos, pos + len);
    }

    public static boolean isHttpUrl(String text) {
        return text.startsWith("http://") || text.startsWith("https://");
    }

    @Nullable
    public static <T extends CharSequence> T defaultIfBlank(@Nullable T str, @Nullable T defaultStr) {
        return StringUtil.isBlank(str) ? defaultStr : str;
    }
}

