/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.security.Key;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import net.dreamlu.mica.core.utils.Charsets;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.core.utils.HexUtil;
import net.dreamlu.mica.core.utils.Holder;
import net.dreamlu.mica.core.utils.StringUtil;
import org.springframework.lang.Nullable;
import org.springframework.util.Base64Utils;

public class DesUtil {
    public static final String DES_ALGORITHM = "DES";

    public static String genDesKey() {
        return StringUtil.random(16);
    }

    public static String encryptToHex(byte[] data, String password) {
        return HexUtil.encodeToString(DesUtil.encrypt(data, password));
    }

    @Nullable
    public static String encryptToHex(@Nullable String data, String password) {
        if (StringUtil.isBlank(data)) {
            return null;
        }
        byte[] dataBytes = data.getBytes(Charsets.UTF_8);
        return DesUtil.encryptToHex(dataBytes, password);
    }

    @Nullable
    public static String decryptFormHex(@Nullable String data, String password) {
        if (StringUtil.isBlank(data)) {
            return null;
        }
        byte[] hexBytes = HexUtil.decode(data);
        return new String(DesUtil.decrypt(hexBytes, password), Charsets.UTF_8);
    }

    public static String encryptToBase64(byte[] data, String password) {
        return Base64Utils.encodeToString((byte[])DesUtil.encrypt(data, password));
    }

    @Nullable
    public static String encryptToBase64(@Nullable String data, String password) {
        if (StringUtil.isBlank(data)) {
            return null;
        }
        byte[] dataBytes = data.getBytes(Charsets.UTF_8);
        return DesUtil.encryptToBase64(dataBytes, password);
    }

    public static byte[] decryptFormBase64(byte[] data, String password) {
        byte[] dataBytes = Base64Utils.decode((byte[])data);
        return DesUtil.decrypt(dataBytes, password);
    }

    @Nullable
    public static String decryptFormBase64(@Nullable String data, String password) {
        if (StringUtil.isBlank(data)) {
            return null;
        }
        byte[] dataBytes = Base64Utils.decodeFromString((String)data);
        return new String(DesUtil.decrypt(dataBytes, password), Charsets.UTF_8);
    }

    public static byte[] encrypt(byte[] data, byte[] desKey) {
        return DesUtil.des(data, desKey, 1);
    }

    public static byte[] encrypt(byte[] data, String desKey) {
        return DesUtil.encrypt(data, Objects.requireNonNull(desKey).getBytes(Charsets.UTF_8));
    }

    public static byte[] decrypt(byte[] data, byte[] desKey) {
        return DesUtil.des(data, desKey, 2);
    }

    public static byte[] decrypt(byte[] data, String desKey) {
        return DesUtil.decrypt(data, Objects.requireNonNull(desKey).getBytes(Charsets.UTF_8));
    }

    private static byte[] des(byte[] data, byte[] desKey, int mode) {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES_ALGORITHM);
            Cipher cipher = Cipher.getInstance(DES_ALGORITHM);
            DESKeySpec desKeySpec = new DESKeySpec(desKey);
            cipher.init(mode, (Key)keyFactory.generateSecret(desKeySpec), Holder.SECURE_RANDOM);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }
}

