/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.validation.constraintvalidators;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import net.dreamlu.mica.core.utils.CollectionUtil;
import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.core.validation.constraints.RangeIn;

public class RangeInValidator
implements ConstraintValidator<RangeIn, Object> {
    private RangeIn rangeIn;

    public void initialize(RangeIn constraintAnnotation) {
        this.rangeIn = constraintAnnotation;
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        String[] ranges = StringUtil.splitTrim(this.rangeIn.value(), ",");
        if (value instanceof CharSequence) {
            CharSequence obj = (CharSequence)value;
            return CollectionUtil.contains(ranges, obj);
        }
        if (value instanceof Number) {
            Number obj = (Number)value;
            return CollectionUtil.contains(ranges, obj.toString());
        }
        if (value instanceof Collection) {
            Collection obj = (Collection)value;
            return obj.stream().allMatch(it -> CollectionUtil.contains(ranges, it.toString()));
        }
        if (value instanceof Iterable) {
            Iterable obj = (Iterable)value;
            AtomicBoolean flag = new AtomicBoolean(true);
            obj.forEach(it -> {
                if (!CollectionUtil.contains(ranges, it.toString())) {
                    flag.set(false);
                }
            });
            return flag.get();
        }
        if (value instanceof Object[]) {
            Object[] obj = (Object[])value;
            return Arrays.stream(obj).allMatch(it -> CollectionUtil.contains(ranges, it.toString()));
        }
        return false;
    }
}

