/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.ip2region.core;

import net.dreamlu.mica.ip2region.utils.Ip2regionUtil;

public class IndexBlock {
    private static final int LENGTH = 12;
    private long startIp;
    private long endIp;
    private int dataPtr;
    private int dataLen;

    public IndexBlock(long startIp, long endIp, int dataPtr, int dataLen) {
        this.startIp = startIp;
        this.endIp = endIp;
        this.dataPtr = dataPtr;
        this.dataLen = dataLen;
    }

    public long getStartIp() {
        return this.startIp;
    }

    public IndexBlock setStartIp(long startIp) {
        this.startIp = startIp;
        return this;
    }

    public long getEndIp() {
        return this.endIp;
    }

    public IndexBlock setEndIp(long endIp) {
        this.endIp = endIp;
        return this;
    }

    public int getDataPtr() {
        return this.dataPtr;
    }

    public IndexBlock setDataPtr(int dataPtr) {
        this.dataPtr = dataPtr;
        return this;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    public IndexBlock setDataLen(int dataLen) {
        this.dataLen = dataLen;
        return this;
    }

    public static int getIndexBlockLength() {
        return 12;
    }

    public byte[] getBytes() {
        byte[] b = new byte[12];
        Ip2regionUtil.writeIntLong(b, 0, this.startIp);
        Ip2regionUtil.writeIntLong(b, 4, this.endIp);
        long mix = (long)this.dataPtr | (long)(this.dataLen << 24) & 0xFF000000L;
        Ip2regionUtil.writeIntLong(b, 8, mix);
        return b;
    }
}

