/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.ip2region.impl;

import java.io.IOException;
import java.io.InputStream;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.ip2region.config.Ip2regionProperties;
import net.dreamlu.mica.ip2region.core.DbConfig;
import net.dreamlu.mica.ip2region.core.DbSearcher;
import net.dreamlu.mica.ip2region.core.Ip2regionSearcher;
import net.dreamlu.mica.ip2region.core.IpInfo;
import net.dreamlu.mica.ip2region.impl.ByteArrayDBReader;
import net.dreamlu.mica.ip2region.utils.IpInfoUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StreamUtils;

public class Ip2regionSearcherImpl
implements InitializingBean,
Ip2regionSearcher {
    private final ResourceLoader resourceLoader;
    private final Ip2regionProperties properties;
    private DbSearcher searcher;

    public void afterPropertiesSet() throws Exception {
        DbConfig config = new DbConfig();
        Resource resource = this.resourceLoader.getResource(this.properties.getDbFileLocation());
        try (InputStream inputStream = resource.getInputStream();){
            this.searcher = new DbSearcher(config, new ByteArrayDBReader(StreamUtils.copyToByteArray((InputStream)inputStream)));
        }
    }

    @Override
    public IpInfo memorySearch(long ip) {
        try {
            return IpInfoUtil.toIpInfo(this.searcher.memorySearch(ip));
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }

    @Override
    public IpInfo memorySearch(String ip) {
        try {
            return IpInfoUtil.toIpInfo(this.searcher.memorySearch(ip));
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }

    @Override
    public IpInfo getByIndexPtr(long ptr) {
        try {
            return IpInfoUtil.toIpInfo(this.searcher.getByIndexPtr(ptr));
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }

    @Override
    public IpInfo btreeSearch(long ip) {
        try {
            return IpInfoUtil.toIpInfo(this.searcher.btreeSearch(ip));
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }

    @Override
    public IpInfo btreeSearch(String ip) {
        try {
            return IpInfoUtil.toIpInfo(this.searcher.btreeSearch(ip));
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }

    @Override
    public IpInfo binarySearch(long ip) {
        try {
            return IpInfoUtil.toIpInfo(this.searcher.binarySearch(ip));
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }

    @Override
    public IpInfo binarySearch(String ip) {
        try {
            return IpInfoUtil.toIpInfo(this.searcher.binarySearch(ip));
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }

    public Ip2regionSearcherImpl(ResourceLoader resourceLoader, Ip2regionProperties properties) {
        this.resourceLoader = resourceLoader;
        this.properties = properties;
    }
}

