/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.ip2region.utils;

import java.util.Arrays;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.dreamlu.mica.ip2region.core.DataBlock;
import net.dreamlu.mica.ip2region.core.IpInfo;
import org.springframework.lang.Nullable;

public class IpInfoUtil {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\|");

    @Nullable
    public static IpInfo toIpInfo(@Nullable DataBlock dataBlock) {
        if (dataBlock == null) {
            return null;
        }
        IpInfo ipInfo = new IpInfo();
        int cityId = dataBlock.getCityId();
        ipInfo.setCityId(cityId == 0 ? null : Integer.valueOf(cityId));
        ipInfo.setDataPtr(dataBlock.getDataPtr());
        String region = dataBlock.getRegion();
        String[] splitInfos = SPLIT_PATTERN.split(region);
        if (splitInfos.length < 5) {
            splitInfos = Arrays.copyOf(splitInfos, 5);
        }
        ipInfo.setCountry(IpInfoUtil.filterZero(splitInfos[0]));
        ipInfo.setRegion(IpInfoUtil.filterZero(splitInfos[1]));
        ipInfo.setProvince(IpInfoUtil.filterZero(splitInfos[2]));
        ipInfo.setCity(IpInfoUtil.filterZero(splitInfos[3]));
        ipInfo.setIsp(IpInfoUtil.filterZero(splitInfos[4]));
        return ipInfo;
    }

    @Nullable
    private static String filterZero(@Nullable String info) {
        if (info == null || "0".equals(info)) {
            return null;
        }
        return info;
    }

    @Nullable
    public static String readInfo(@Nullable IpInfo ipInfo, Function<IpInfo, String> function) {
        if (ipInfo == null) {
            return null;
        }
        return function.apply(ipInfo);
    }
}

