/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.ip2region.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import net.dreamlu.mica.ip2region.core.DBReader;
import net.dreamlu.mica.ip2region.core.DataBlock;
import net.dreamlu.mica.ip2region.core.DbConfig;
import net.dreamlu.mica.ip2region.core.IndexBlock;
import net.dreamlu.mica.ip2region.impl.RandomAccessFileDBReader;
import net.dreamlu.mica.ip2region.utils.Ip2regionUtil;

public class DbSearcher {
    private final DbConfig dbConfig;
    private final DBReader reader;
    private long[] HeaderSip = null;
    private int[] HeaderPtr = null;
    private int headerLength;
    private long firstIndexPtr = 0L;
    private long lastIndexPtr = 0L;
    private int totalIndexBlocks = 0;
    private byte[] dbBinStr = null;

    public DbSearcher(DbConfig dbConfig, String dbFile) throws FileNotFoundException {
        this(dbConfig, new RandomAccessFileDBReader(new RandomAccessFile(dbFile, "r")));
    }

    public DbSearcher(DbConfig dbConfig, DBReader reader) {
        this.dbConfig = dbConfig;
        this.reader = reader;
    }

    public DataBlock memorySearch(long ip) throws IOException {
        int blen = IndexBlock.getIndexBlockLength();
        if (this.dbBinStr == null) {
            this.dbBinStr = this.reader.full();
            this.firstIndexPtr = Ip2regionUtil.getIntLong(this.dbBinStr, 0);
            this.lastIndexPtr = Ip2regionUtil.getIntLong(this.dbBinStr, 4);
            this.totalIndexBlocks = (int)((this.lastIndexPtr - this.firstIndexPtr) / (long)blen) + 1;
        }
        int l = 0;
        int h = this.totalIndexBlocks;
        long dataptr = 0L;
        while (l <= h) {
            int m = l + h >> 1;
            int p = (int)(this.firstIndexPtr + (long)(m * blen));
            long sip = Ip2regionUtil.getIntLong(this.dbBinStr, p);
            if (ip < sip) {
                h = m - 1;
                continue;
            }
            long eip = Ip2regionUtil.getIntLong(this.dbBinStr, p + 4);
            if (ip > eip) {
                l = m + 1;
                continue;
            }
            dataptr = Ip2regionUtil.getIntLong(this.dbBinStr, p + 8);
            break;
        }
        if (dataptr == 0L) {
            return null;
        }
        int dataLen = (int)(dataptr >> 24 & 0xFFL);
        int dataPtr = (int)(dataptr & 0xFFFFFFL);
        int cityId = (int)Ip2regionUtil.getIntLong(this.dbBinStr, dataPtr);
        String region = new String(this.dbBinStr, dataPtr + 4, dataLen - 4, StandardCharsets.UTF_8);
        return new DataBlock(cityId, region, dataPtr);
    }

    public DataBlock memorySearch(String ip) throws IOException {
        return this.memorySearch(Ip2regionUtil.ip2long(ip));
    }

    public DataBlock getByIndexPtr(long ptr) throws IOException {
        byte[] buffer = new byte[12];
        this.reader.readFully(ptr, buffer, 0, buffer.length);
        long extra = Ip2regionUtil.getIntLong(buffer, 8);
        int dataLen = (int)(extra >> 24 & 0xFFL);
        int dataPtr = (int)(extra & 0xFFFFFFL);
        byte[] data = new byte[dataLen];
        this.reader.readFully(dataPtr, data, 0, data.length);
        int cityId = (int)Ip2regionUtil.getIntLong(data, 0);
        String region = new String(data, 4, data.length - 4, StandardCharsets.UTF_8);
        return new DataBlock(cityId, region, dataPtr);
    }

    public DataBlock btreeSearch(long ip) throws IOException {
        if (this.HeaderSip == null) {
            byte[] b = new byte[8192];
            this.reader.readFully(8L, b, 0, b.length);
            int len = b.length >> 3;
            int idx = 0;
            long[] headerSip = new long[len];
            int[] headerPtr = new int[len];
            for (int i = 0; i < b.length; i += 8) {
                long startIp = Ip2regionUtil.getIntLong(b, i);
                long dataPtr = Ip2regionUtil.getIntLong(b, i + 4);
                if (dataPtr == 0L) break;
                headerSip[idx] = startIp;
                headerPtr[idx] = (int)dataPtr;
                ++idx;
            }
            this.headerLength = idx;
            this.HeaderPtr = headerPtr;
            this.HeaderSip = headerSip;
        }
        if (ip == this.HeaderSip[0]) {
            return this.getByIndexPtr(this.HeaderPtr[0]);
        }
        if (ip == this.HeaderSip[this.headerLength - 1]) {
            return this.getByIndexPtr(this.HeaderPtr[this.headerLength - 1]);
        }
        int l = 0;
        int h = this.headerLength;
        int sptr = 0;
        int eptr = 0;
        while (l <= h) {
            int m = l + h >> 1;
            if (ip == this.HeaderSip[m]) {
                if (m > 0) {
                    sptr = this.HeaderPtr[m - 1];
                    eptr = this.HeaderPtr[m];
                    break;
                }
                sptr = this.HeaderPtr[m];
                eptr = this.HeaderPtr[m + 1];
                break;
            }
            if (ip < this.HeaderSip[m]) {
                if (m == 0) {
                    sptr = this.HeaderPtr[m];
                    eptr = this.HeaderPtr[m + 1];
                    break;
                }
                if (ip > this.HeaderSip[m - 1]) {
                    sptr = this.HeaderPtr[m - 1];
                    eptr = this.HeaderPtr[m];
                    break;
                }
                h = m - 1;
                continue;
            }
            if (m == this.headerLength - 1) {
                sptr = this.HeaderPtr[m - 1];
                eptr = this.HeaderPtr[m];
                break;
            }
            if (ip <= this.HeaderSip[m + 1]) {
                sptr = this.HeaderPtr[m];
                eptr = this.HeaderPtr[m + 1];
                break;
            }
            l = m + 1;
        }
        if (sptr == 0) {
            return null;
        }
        int blockLen = eptr - sptr;
        int blen = IndexBlock.getIndexBlockLength();
        byte[] iBuffer = new byte[blockLen + blen];
        this.reader.readFully(sptr, iBuffer, 0, iBuffer.length);
        l = 0;
        h = blockLen / blen;
        long dataptr = 0L;
        while (l <= h) {
            int m = l + h >> 1;
            int p = m * blen;
            long sip = Ip2regionUtil.getIntLong(iBuffer, p);
            if (ip < sip) {
                h = m - 1;
                continue;
            }
            long eip = Ip2regionUtil.getIntLong(iBuffer, p + 4);
            if (ip > eip) {
                l = m + 1;
                continue;
            }
            dataptr = Ip2regionUtil.getIntLong(iBuffer, p + 8);
            break;
        }
        if (dataptr == 0L) {
            return null;
        }
        int dataLen = (int)(dataptr >> 24 & 0xFFL);
        int dataPtr = (int)(dataptr & 0xFFFFFFL);
        byte[] data = new byte[dataLen];
        this.reader.readFully(dataPtr, data, 0, data.length);
        int cityId = (int)Ip2regionUtil.getIntLong(data, 0);
        String region = new String(data, 4, data.length - 4, StandardCharsets.UTF_8);
        return new DataBlock(cityId, region, dataPtr);
    }

    public DataBlock btreeSearch(String ip) throws IOException {
        return this.btreeSearch(Ip2regionUtil.ip2long(ip));
    }

    public DataBlock binarySearch(long ip) throws IOException {
        int blen = IndexBlock.getIndexBlockLength();
        if (this.totalIndexBlocks == 0) {
            byte[] superBytes = new byte[8];
            this.reader.readFully(0L, superBytes, 0, superBytes.length);
            this.firstIndexPtr = Ip2regionUtil.getIntLong(superBytes, 0);
            this.lastIndexPtr = Ip2regionUtil.getIntLong(superBytes, 4);
            this.totalIndexBlocks = (int)((this.lastIndexPtr - this.firstIndexPtr) / (long)blen) + 1;
        }
        int l = 0;
        int h = this.totalIndexBlocks;
        byte[] buffer = new byte[blen];
        long dataptr = 0L;
        while (l <= h) {
            int m = l + h >> 1;
            this.reader.readFully(this.firstIndexPtr + (long)(m * blen), buffer, 0, buffer.length);
            long sip = Ip2regionUtil.getIntLong(buffer, 0);
            if (ip < sip) {
                h = m - 1;
                continue;
            }
            long eip = Ip2regionUtil.getIntLong(buffer, 4);
            if (ip > eip) {
                l = m + 1;
                continue;
            }
            dataptr = Ip2regionUtil.getIntLong(buffer, 8);
            break;
        }
        if (dataptr == 0L) {
            return null;
        }
        int dataLen = (int)(dataptr >> 24 & 0xFFL);
        int dataPtr = (int)(dataptr & 0xFFFFFFL);
        byte[] data = new byte[dataLen];
        this.reader.readFully(dataPtr, data, 0, data.length);
        int cityId = (int)Ip2regionUtil.getIntLong(data, 0);
        String region = new String(data, 4, data.length - 4, StandardCharsets.UTF_8);
        return new DataBlock(cityId, region, dataPtr);
    }

    public DataBlock binarySearch(String ip) throws IOException {
        return this.binarySearch(Ip2regionUtil.ip2long(ip));
    }

    public DbConfig getDbConfig() {
        return this.dbConfig;
    }

    public void close() throws IOException {
        this.HeaderSip = null;
        this.HeaderPtr = null;
        this.dbBinStr = null;
        this.reader.close();
    }
}

