/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.ip2region.utils;

public class Ip2regionUtil {
    public static void write(byte[] b, int offset, long v, int bytes) {
        for (int i = 0; i < bytes; ++i) {
            b[offset++] = (byte)(v >>> 8 * i & 0xFFL);
        }
    }

    public static void writeIntLong(byte[] b, int offset, long v) {
        b[offset++] = (byte)(v & 0xFFL);
        b[offset++] = (byte)(v >> 8 & 0xFFL);
        b[offset++] = (byte)(v >> 16 & 0xFFL);
        b[offset] = (byte)(v >> 24 & 0xFFL);
    }

    public static long getIntLong(byte[] b, int offset) {
        return (long)b[offset++] & 0xFFL | (long)(b[offset++] << 8) & 0xFF00L | (long)(b[offset++] << 16) & 0xFF0000L | (long)(b[offset] << 24) & 0xFF000000L;
    }

    public static int getInt3(byte[] b, int offset) {
        return b[offset++] & 0xFF | b[offset++] & 0xFF00 | b[offset] & 0xFF0000;
    }

    public static int getInt2(byte[] b, int offset) {
        return b[offset++] & 0xFF | b[offset] & 0xFF00;
    }

    public static int getInt1(byte[] b, int offset) {
        return b[offset] & 0xFF;
    }

    public static long ip2long(String ip) {
        String[] p = ip.split("\\.");
        if (p.length != 4) {
            return 0L;
        }
        int p1 = Integer.parseInt(p[0]) << 24 & 0xFF000000;
        int p2 = Integer.parseInt(p[1]) << 16 & 0xFF0000;
        int p3 = Integer.parseInt(p[2]) << 8 & 0xFF00;
        int p4 = Integer.parseInt(p[3]) & 0xFF;
        return (long)(p1 | p2 | p3 | p4) & 0xFFFFFFFFL;
    }

    public static String long2ip(long ip) {
        return String.valueOf(ip >> 24 & 0xFFL) + '.' + (ip >> 16 & 0xFFL) + '.' + (ip >> 8 & 0xFFL) + '.' + (ip & 0xFFL);
    }

    public static boolean isIpAddress(String ip) {
        String[] p = ip.split("\\.");
        if (p.length != 4) {
            return false;
        }
        for (String pp : p) {
            if (pp.length() > 3) {
                return false;
            }
            int val = Integer.parseInt(pp);
            if (val <= 255) continue;
            return false;
        }
        return true;
    }
}

