/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.ip2region.impl;

import java.io.IOException;
import java.io.InputStream;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.ip2region.config.Ip2regionProperties;
import net.dreamlu.mica.ip2region.core.Ip2regionSearcher;
import net.dreamlu.mica.ip2region.core.IpInfo;
import net.dreamlu.mica.ip2region.core.Searcher;
import net.dreamlu.mica.ip2region.utils.IpInfoUtil;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StreamUtils;

public class Ip2regionSearcherImpl
implements InitializingBean,
DisposableBean,
Ip2regionSearcher {
    private final ResourceLoader resourceLoader;
    private final Ip2regionProperties properties;
    private Searcher searcher;

    @Override
    public IpInfo memorySearch(long ip) {
        try {
            return IpInfoUtil.toIpInfo(this.searcher.search(ip));
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }

    @Override
    public IpInfo memorySearch(String ip) {
        try {
            return IpInfoUtil.toIpInfo(this.searcher.search(ip));
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Resource resource = this.resourceLoader.getResource(this.properties.getDbFileLocation());
        try (InputStream inputStream = resource.getInputStream();){
            this.searcher = Searcher.newWithBuffer(StreamUtils.copyToByteArray((InputStream)inputStream));
        }
    }

    public void destroy() throws Exception {
        if (this.searcher != null) {
            this.searcher.close();
        }
    }

    public Ip2regionSearcherImpl(ResourceLoader resourceLoader, Ip2regionProperties properties) {
        this.resourceLoader = resourceLoader;
        this.properties = properties;
    }
}

