/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Function;
import net.dreamlu.mica.core.utils.CollectionUtil;
import net.dreamlu.mica.core.utils.SystemUtil;
import net.dreamlu.mica.launcher.LauncherService;
import net.dreamlu.mica.launcher.MicaEnv;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SimpleCommandLinePropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MicaApplication {
    public static ConfigurableApplicationContext run(String appName, Class source, String ... args) {
        SpringApplicationBuilder builder = MicaApplication.createSpringApplicationBuilder(appName, source, args);
        return builder.run(args);
    }

    public static SpringApplicationBuilder createSpringApplicationBuilder(String appName, Class source, String ... args) {
        String profile;
        Assert.hasText((String)appName, (String)"args appName is blank");
        StandardEnvironment env = new StandardEnvironment();
        MutablePropertySources propertySources = env.getPropertySources();
        propertySources.addFirst((PropertySource)new SimpleCommandLinePropertySource(args));
        propertySources.addLast((PropertySource)new MapPropertySource("systemProperties", env.getSystemProperties()));
        propertySources.addLast((PropertySource)new SystemEnvironmentPropertySource("systemEnvironment", env.getSystemEnvironment()));
        String[] activeProfiles = env.getActiveProfiles();
        List<String> profiles = Arrays.asList(activeProfiles);
        List<String> presetProfiles = MicaEnv.getEnvList();
        presetProfiles.retainAll(profiles);
        ArrayList<String> activeProfileList = new ArrayList<String>(profiles);
        Function<Object[], String> joinFun = StringUtils::arrayToCommaDelimitedString;
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{source});
        if (presetProfiles.isEmpty()) {
            profile = MicaEnv.DEV.getName();
            activeProfileList.add(profile);
            builder.profiles(new String[]{profile});
        } else if (presetProfiles.size() == 1) {
            profile = presetProfiles.get(0);
        } else {
            throw new IllegalArgumentException("\u540c\u65f6\u5b58\u5728\u73af\u5883\u53d8\u91cf:[" + joinFun.apply(activeProfiles) + "]");
        }
        String startJarPath = MicaApplication.class.getResource("/").getPath().split("!")[0];
        String activePros = joinFun.apply(activeProfileList.toArray());
        System.err.println(String.format("---[%s]---\u542f\u52a8\u4e2d\uff0c\u8bfb\u53d6\u5230\u7684\u73af\u5883\u53d8\u91cf:[%s]\uff0cjar\u5730\u5740:[%s]---", appName, activePros, startJarPath));
        boolean isLocalDev = SystemUtil.isLocalDev();
        System.setProperty("spring.application.name", appName);
        System.setProperty("mica.env", profile);
        Properties defaultProperties = new Properties();
        defaultProperties.setProperty("mica.is-local", String.valueOf(isLocalDev));
        defaultProperties.setProperty("spring.banner.location", "classpath:banner.txt");
        MicaEnv micaEnv = MicaEnv.of(profile);
        defaultProperties.setProperty("mica.log.request.level", micaEnv.getReqLogLevel().name());
        ServiceLoader<LauncherService> loader = ServiceLoader.load(LauncherService.class);
        CollectionUtil.toList(loader).stream().sorted().forEach(arg_0 -> MicaApplication.lambda$createSpringApplicationBuilder$0(builder, (ConfigurableEnvironment)env, appName, micaEnv, isLocalDev, arg_0));
        builder.properties(defaultProperties);
        return builder;
    }

    private static /* synthetic */ void lambda$createSpringApplicationBuilder$0(SpringApplicationBuilder builder, ConfigurableEnvironment env, String appName, MicaEnv micaEnv, boolean isLocalDev, LauncherService launcherService) {
        launcherService.launcher(builder, (Environment)env, appName, micaEnv, isLocalDev);
    }
}

