/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.launcher;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.dreamlu.mica.launcher.MicaLogLevel;

public enum MicaEnv {
    DEV("dev", "debug", MicaLogLevel.BODY),
    TEST("test", "info", MicaLogLevel.BODY),
    ON_TEST("ontest", "info", MicaLogLevel.HEADERS),
    PROD("prod", "warn", MicaLogLevel.NONE);

    private String name;
    private String logFileLevel;
    private MicaLogLevel reqLogLevel;

    public static List<String> getEnvList() {
        return Arrays.stream(MicaEnv.values()).map(MicaEnv::getName).collect(Collectors.toList());
    }

    public static MicaEnv of(String env) {
        MicaEnv[] values;
        for (MicaEnv micaEnv : values = MicaEnv.values()) {
            if (!micaEnv.name.equals(env)) continue;
            return micaEnv;
        }
        return DEV;
    }

    public String getName() {
        return this.name;
    }

    public String getLogFileLevel() {
        return this.logFileLevel;
    }

    public MicaLogLevel getReqLogLevel() {
        return this.reqLogLevel;
    }

    private MicaEnv(String name, String logFileLevel, MicaLogLevel reqLogLevel) {
        this.name = name;
        this.logFileLevel = logFileLevel;
        this.reqLogLevel = reqLogLevel;
    }
}

