/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.launcher;

import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
public class StartedEventListener {
    @Async
    @Order(value=0x7FFFFFFE)
    @EventListener(value={WebServerInitializedEvent.class})
    public void afterStart(WebServerInitializedEvent event) {
        Environment environment = event.getApplicationContext().getEnvironment();
        String appName = environment.getProperty("spring.application.name");
        int localPort = event.getWebServer().getPort();
        String profile = StringUtils.arrayToCommaDelimitedString((Object[])environment.getActiveProfiles());
        System.err.println(String.format("---[%s]---\u542f\u52a8\u5b8c\u6210\uff0c\u5f53\u524d\u4f7f\u7528\u7684\u7aef\u53e3:[%d]\uff0c\u73af\u5883\u53d8\u91cf:[%s]---", appName, localPort, profile));
        if (ClassUtils.isPresent((String)"springfox.documentation.spring.web.plugins.Docket", null)) {
            System.out.println(String.format("http://localhost:%s/doc.html", localPort));
        } else {
            System.out.println(String.format("http://localhost:%s", localPort));
        }
    }
}

