/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.props;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@RefreshScope
@ConfigurationProperties(value="mica")
public class MicaProperties
implements EnvironmentAware,
EnvironmentCapable {
    @Nullable
    @JsonIgnore
    private Environment environment;
    private Boolean isLocal = Boolean.FALSE;
    private final Map<String, String> prop = new HashMap<String, String>();

    @Nullable
    public String get(String key) {
        return this.get(key, null);
    }

    @Nullable
    public String get(String key, @Nullable String defaultValue) {
        String value = this.prop.get(key);
        if (!StringUtils.hasText((String)value)) {
            return defaultValue;
        }
        return value;
    }

    @Nullable
    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    @Nullable
    public Integer getInt(String key, @Nullable Integer defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            return Integer.valueOf(value.trim());
        }
        return defaultValue;
    }

    @Nullable
    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    @Nullable
    public Long getLong(String key, @Nullable Long defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            return Long.valueOf(value.trim());
        }
        return defaultValue;
    }

    @Nullable
    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    @Nullable
    public Boolean getBoolean(String key, @Nullable Boolean defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            if ("true".equals(value = value.toLowerCase().trim())) {
                return Boolean.TRUE;
            }
            if ("false".equals(value)) {
                return Boolean.FALSE;
            }
        }
        return defaultValue;
    }

    public boolean containsKey(String key) {
        return this.prop.containsKey(key);
    }

    public String getEnv() {
        Objects.requireNonNull(this.environment, "Spring boot \u73af\u5883\u4e0b Environment \u4e0d\u53ef\u80fd\u4e3anull\u3002");
        String env = this.environment.getProperty("mica.env");
        Assert.notNull((Object)env, (String)"\u8bf7\u4f7f\u7528 MicaApplication \u542f\u52a8...");
        return env;
    }

    public String getName() {
        Objects.requireNonNull(this.environment, "Spring boot \u73af\u5883\u4e0b Environment \u4e0d\u53ef\u80fd\u4e3anull\u3002");
        return this.environment.getProperty("spring.application.name", "");
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        Objects.requireNonNull(this.environment, "Spring boot \u73af\u5883\u4e0b Environment \u4e0d\u53ef\u80fd\u4e3anull\u3002");
        return this.environment;
    }

    public Boolean getIsLocal() {
        return this.isLocal;
    }

    public void setIsLocal(Boolean isLocal) {
        this.isLocal = isLocal;
    }

    public Map<String, String> getProp() {
        return this.prop;
    }
}

