/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.lite.error;

import java.time.LocalDateTime;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.core.utils.ObjectUtil;
import net.dreamlu.mica.lite.error.MicaErrorEvent;

public final class ErrorUtil {
    public static void initErrorInfo(Throwable error, MicaErrorEvent event) {
        event.setStackTrace(Exceptions.getStackTraceAsString((Throwable)error));
        event.setExceptionName(error.getClass().getName());
        event.setMessage(error.getMessage());
        event.setCreatedAt(LocalDateTime.now());
        Object[] elements = error.getStackTrace();
        if (ObjectUtil.isNotEmpty((Object[])elements)) {
            Object element = elements[0];
            event.setClassName(((StackTraceElement)element).getClassName());
            event.setFileName(((StackTraceElement)element).getFileName());
            event.setMethodName(((StackTraceElement)element).getMethodName());
            event.setLineNumber(((StackTraceElement)element).getLineNumber());
        }
    }

    private ErrorUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

