/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.lite.error;

import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import net.dreamlu.mica.core.context.DefaultMicaContext;
import net.dreamlu.mica.core.context.IMicaContext;
import net.dreamlu.mica.core.exception.ServiceException;
import net.dreamlu.mica.core.result.IResultCode;
import net.dreamlu.mica.core.result.R;
import net.dreamlu.mica.core.result.SystemCode;
import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.core.utils.WebUtil;
import net.dreamlu.mica.lite.error.ErrorType;
import net.dreamlu.mica.lite.error.ErrorUtil;
import net.dreamlu.mica.lite.error.MicaErrorEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.DispatcherServlet;

@Order
@RestControllerAdvice
@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class MicaExceptionTranslator {
    private static final Logger log = LoggerFactory.getLogger(MicaExceptionTranslator.class);
    private final IMicaContext micaContext;
    private final ApplicationEventPublisher publisher;

    @Autowired
    public MicaExceptionTranslator(ObjectProvider<IMicaContext> micaContextProvider, ApplicationEventPublisher publisher) {
        this.micaContext = (IMicaContext)micaContextProvider.getIfAvailable(DefaultMicaContext::new);
        this.publisher = publisher;
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<Object> handleError(ServiceException e) {
        log.error("\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
        R result = e.getResult();
        if (result == null) {
            result = R.fail((IResultCode)SystemCode.FAILURE, (String)e.getMessage());
            this.publishEvent((Throwable)e);
        }
        return result;
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<Object> handleError(Throwable e) {
        log.error("\u672a\u77e5\u5f02\u5e38", e);
        this.publishEvent(e);
        return R.fail((IResultCode)SystemCode.FAILURE);
    }

    private void publishEvent(Throwable error) {
        MicaErrorEvent event = new MicaErrorEvent();
        event.setErrorType(ErrorType.REQUEST);
        event.setRequestId(this.micaContext.getRequestId());
        HttpServletRequest request = WebUtil.getRequest();
        event.setRequestMethod(request.getMethod());
        String requestUrl = request.getRequestURI();
        String queryString = request.getQueryString();
        if (StringUtil.isNotBlank((CharSequence)queryString)) {
            requestUrl = requestUrl + "?" + queryString;
        }
        event.setRequestIp(WebUtil.getIP((HttpServletRequest)request));
        event.setRequestUrl(requestUrl);
        ErrorUtil.initErrorInfo(error, event);
        this.publisher.publishEvent((Object)event);
    }
}

