/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.lite.upload;

import net.dreamlu.mica.lite.upload.MicaUploadProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="mica.upload", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class MicaServletUploadConfiguration
implements WebMvcConfigurer {
    private final MicaUploadProperties properties;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String path = this.properties.getSavePath();
        registry.addResourceHandler(new String[]{this.properties.getUploadPathPattern()}).addResourceLocations(new String[]{"file:" + path + "/"});
    }

    public MicaServletUploadConfiguration(MicaUploadProperties properties) {
        this.properties = properties;
    }
}

