/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.lite.base;

import java.io.File;
import java.nio.charset.Charset;
import net.dreamlu.mica.core.result.IResultCode;
import net.dreamlu.mica.core.result.R;
import net.dreamlu.mica.core.result.SystemCode;
import net.dreamlu.mica.core.utils.Charsets;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriUtils;

public interface IController {
    default public String redirect(String url) {
        return "redirect:".concat(url);
    }

    default public <T> R<T> success() {
        return R.success();
    }

    default public <T> R<T> success(@Nullable T data) {
        return R.success(data);
    }

    default public <T> R<T> status(boolean status, String msg) {
        return R.status((boolean)status, (String)msg);
    }

    default public <T> R<T> status(boolean status, IResultCode sCode) {
        return R.status((boolean)status, (IResultCode)sCode);
    }

    default public <T> R<T> fail(String msg) {
        return R.fail((IResultCode)SystemCode.FAILURE, (String)msg);
    }

    default public <T> R<T> fail(IResultCode rCode) {
        return R.fail((IResultCode)rCode);
    }

    default public <T> R<T> fail(IResultCode rCode, String msg) {
        return R.fail((IResultCode)rCode, (String)msg);
    }

    default public ResponseEntity<Resource> download(File file) {
        String fileName = file.getName();
        return this.download(file, fileName);
    }

    default public ResponseEntity<Resource> download(File file, String fileName) {
        FileSystemResource resource = new FileSystemResource(file);
        return this.download((Resource)resource, fileName);
    }

    default public ResponseEntity<Resource> download(Resource resource, String fileName) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        String encodeFileName = UriUtils.encode((String)fileName, (Charset)Charsets.UTF_8);
        String disposition = "attachment;filename=\"" + encodeFileName + "\";filename*=utf-8''" + encodeFileName;
        headers.set("Content-Disposition", disposition);
        return new ResponseEntity((Object)resource, (MultiValueMap)headers, HttpStatus.OK);
    }
}

