/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.lite.launch;

import java.io.PrintStream;
import java.util.stream.Stream;
import net.dreamlu.mica.core.log.LogPrintStream;
import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.core.utils.SystemUtil;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@AutoConfiguration
public class StartedEventListener {
    @Async
    @Order(value=0x7FFFFFFE)
    @EventListener(value={WebServerInitializedEvent.class})
    public void afterStart(WebServerInitializedEvent event) {
        WebServerApplicationContext context = event.getApplicationContext();
        Environment environment = context.getEnvironment();
        String appName = environment.getRequiredProperty("spring.application.name");
        int localPort = event.getWebServer().getPort();
        String profile = StringUtils.arrayToCommaDelimitedString((Object[])environment.getActiveProfiles());
        System.err.printf("---[%s]---\u542f\u52a8\u5b8c\u6210\uff0c\u5f53\u524d\u4f7f\u7528\u7684\u7aef\u53e3:[%d]\uff0c\u73af\u5883\u53d8\u91cf:[%s]---%n", appName, localPort, profile);
        if (StartedEventListener.hasKnife4J()) {
            System.out.printf("http://localhost:%s/doc.html%n", localPort);
        } else if (StartedEventListener.hasOpenApi()) {
            String swaggerPath = (String)StringUtil.defaultIfBlank((CharSequence)environment.getProperty("springdoc.swagger-ui.path"), (CharSequence)"/swagger-ui.html");
            System.out.printf("http://localhost:%s%s%n", localPort, swaggerPath);
        } else {
            System.out.printf("http://localhost:%s%n", localPort);
        }
        if (SystemUtil.isLinux()) {
            System.setOut((PrintStream)LogPrintStream.log((boolean)false));
        }
    }

    private static boolean hasOpenApi() {
        return Stream.of("springfox.documentation.spring.web.plugins.Docket", "io.swagger.v3.oas.models.OpenAPI").anyMatch(clazz -> ClassUtils.isPresent((String)clazz, null));
    }

    private static boolean hasKnife4J() {
        return Stream.of("com.github.xiaoymin.knife4j.core.conf.Consts", "com.github.xiaoymin.knife4j.core.conf.GlobalConstants").anyMatch(clazz -> ClassUtils.isPresent((String)clazz, null));
    }
}

