/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.log;

import net.dreamlu.mica.config.SpringUtils;
import net.dreamlu.mica.core.utils.ObjectUtil;
import net.dreamlu.mica.props.MicaProperties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.springframework.core.env.Environment;

@Plugin(name="EnvironmentFilter", category="Core", elementType="filter", printObject=true)
@PerformanceSensitive(value={"allocation"})
public class EnvironmentFilter
extends AbstractFilter {
    public EnvironmentFilter() {
        super(Filter.Result.ACCEPT, Filter.Result.DENY);
    }

    protected Filter.Result filterByEnvironment() {
        MicaProperties micaProperties = (MicaProperties)SpringUtils.getBean(MicaProperties.class);
        if (micaProperties == null) {
            return Filter.Result.ACCEPT;
        }
        Boolean isLocal = micaProperties.getIsLocal();
        if (ObjectUtil.isTrue((Boolean)isLocal)) {
            return Filter.Result.ACCEPT;
        }
        Environment environment = micaProperties.getEnvironment();
        Boolean isConsoleEnabled = (Boolean)environment.getProperty("mica.log.console.enabled", Boolean.class);
        if (ObjectUtil.isTrue((Boolean)isConsoleEnabled)) {
            return Filter.Result.ACCEPT;
        }
        return Filter.Result.DENY;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        return this.filterByEnvironment();
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        return this.filterByEnvironment();
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return this.filterByEnvironment();
    }

    public Filter.Result filter(LogEvent event) {
        return this.filterByEnvironment();
    }

    @PluginFactory
    public static EnvironmentFilter createFilter() {
        return new EnvironmentFilter();
    }
}

