/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.log;

import java.util.Map;
import net.dreamlu.mica.log.LogPrintStream;
import net.dreamlu.mica.props.MicaProperties;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.scheduling.annotation.Async;

@Configuration
public class StartedEventListener {
    @Async
    @Order
    @EventListener(value={WebServerInitializedEvent.class})
    public void afterStart(WebServerInitializedEvent event) {
        ConfigurableEnvironment environment;
        WebServerApplicationContext applicationContext = event.getApplicationContext();
        MicaProperties micaProperties = (MicaProperties)applicationContext.getBean(MicaProperties.class);
        if (!micaProperties.getIsLocal().booleanValue()) {
            System.setOut(LogPrintStream.out());
            System.setErr(LogPrintStream.err());
        }
        if (!(environment = (ConfigurableEnvironment)applicationContext.getEnvironment()).containsProperty("mica.log.console.enabled")) {
            Map systemProperties = environment.getSystemProperties();
            systemProperties.put("mica.log.console.enabled", false);
        }
    }
}

