/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.logging.appender;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import com.github.loki4j.logback.AbstractHttpSender;
import com.github.loki4j.logback.AbstractLoki4jEncoder;
import com.github.loki4j.logback.ApacheHttpSender;
import com.github.loki4j.logback.HttpSender;
import com.github.loki4j.logback.JavaHttpSender;
import com.github.loki4j.logback.JsonEncoder;
import com.github.loki4j.logback.Loki4jAppender;
import com.github.loki4j.logback.Loki4jEncoder;
import com.github.loki4j.logback.ProtobufEncoder;
import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.logging.appender.ILoggingAppender;
import net.dreamlu.mica.logging.config.MicaLoggingProperties;
import net.dreamlu.mica.logging.loki.OkHttpSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class LoggingLokiAppender
implements ILoggingAppender {
    private static final Logger log = LoggerFactory.getLogger(LoggingLokiAppender.class);
    private static final String APPENDER_NAME = "LOKI";
    private final MicaLoggingProperties properties;
    private final String appName;
    private final String profile;

    public LoggingLokiAppender(Environment environment, MicaLoggingProperties properties) {
        this.properties = properties;
        this.appName = environment.getRequiredProperty("spring.application.name");
        this.profile = environment.getRequiredProperty("spring.profiles.active");
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.start(context);
    }

    @Override
    public void start(LoggerContext context) {
        log.info("Loki logging start.");
        this.reload(context);
    }

    @Override
    public void reset(LoggerContext context) {
        log.info("Loki logging reset.");
        this.reload(context);
    }

    private void reload(LoggerContext context) {
        MicaLoggingProperties.Loki loki = this.properties.getLoki();
        if (loki.isEnabled()) {
            this.addLokiAppender(context, loki);
        }
    }

    private void addLokiAppender(LoggerContext context, MicaLoggingProperties.Loki properties) {
        Loki4jAppender lokiAppender = new Loki4jAppender();
        lokiAppender.setName(APPENDER_NAME);
        lokiAppender.setContext((Context)context);
        lokiAppender.setBatchMaxItems(properties.getBatchMaxItems());
        lokiAppender.setBatchMaxBytes(properties.getBatchMaxBytes());
        lokiAppender.setBatchTimeoutMs(properties.getBatchTimeoutMs());
        lokiAppender.setSendQueueMaxBytes(properties.getSendQueueMaxBytes());
        lokiAppender.setUseDirectBuffers(properties.isUseDirectBuffers());
        lokiAppender.setDrainOnStop(properties.isDrainOnStop());
        lokiAppender.setMetricsEnabled(properties.isMetricsEnabled());
        lokiAppender.setVerbose(properties.isVerbose());
        Loki4jEncoder loki4jEncoder = this.getFormat(context, properties);
        lokiAppender.setFormat(loki4jEncoder);
        lokiAppender.setHttp(LoggingLokiAppender.getSender(context, loki4jEncoder, properties));
        lokiAppender.start();
        context.getLogger("ROOT").detachAppender(APPENDER_NAME);
        context.getLogger("ROOT").addAppender((Appender)lokiAppender);
    }

    private Loki4jEncoder getFormat(LoggerContext context, MicaLoggingProperties.Loki properties) {
        MicaLoggingProperties.LokiEncoder encoder = properties.getEncoder();
        ProtobufEncoder loki4jEncoder = MicaLoggingProperties.LokiEncoder.ProtoBuf == encoder ? new ProtobufEncoder() : new JsonEncoder();
        AbstractLoki4jEncoder.LabelCfg labelCfg = new AbstractLoki4jEncoder.LabelCfg();
        labelCfg.setPattern(this.formatLabelPatternHandle(context, properties));
        labelCfg.setPairSeparator(properties.getFormatLabelPairSeparator());
        labelCfg.setKeyValueSeparator(properties.getFormatLabelKeyValueSeparator());
        labelCfg.setNopex(properties.isFormatLabelNoPex());
        loki4jEncoder.setLabel(labelCfg);
        AbstractLoki4jEncoder.MessageCfg messageCfg = new AbstractLoki4jEncoder.MessageCfg();
        String formatMessagePattern = properties.getFormatMessagePattern();
        if (StringUtil.isNotBlank((CharSequence)formatMessagePattern)) {
            messageCfg.setPattern(formatMessagePattern);
        }
        loki4jEncoder.setMessage(messageCfg);
        loki4jEncoder.setStaticLabels(properties.isFormatStaticLabels());
        loki4jEncoder.setSortByTime(properties.isFormatSortByTime());
        loki4jEncoder.setContext((Context)context);
        loki4jEncoder.start();
        return loki4jEncoder;
    }

    private static HttpSender getSender(LoggerContext context, Loki4jEncoder loki4jEncoder, MicaLoggingProperties.Loki properties) {
        MicaLoggingProperties.HttpSender httpSenderType = LoggingLokiAppender.getHttpSender(properties);
        Object httpSender = MicaLoggingProperties.HttpSender.OKHttp == httpSenderType ? new OkHttpSender() : (MicaLoggingProperties.HttpSender.ApacheHttp == httpSenderType ? new ApacheHttpSender() : new JavaHttpSender());
        httpSender.setUrl(properties.getHttpUrl());
        httpSender.setConnectionTimeoutMs(properties.getHttpConnectionTimeoutMs());
        httpSender.setRequestTimeoutMs(properties.getHttpRequestTimeoutMs());
        String authUsername = properties.getHttpAuthUsername();
        String authPassword = properties.getHttpAuthPassword();
        if (StringUtil.isNotBlank((CharSequence)authUsername) && StringUtil.isNotBlank((CharSequence)authPassword)) {
            AbstractHttpSender.BasicAuth basicAuth = new AbstractHttpSender.BasicAuth();
            basicAuth.setUsername(authUsername);
            basicAuth.setPassword(authPassword);
            httpSender.setAuth(basicAuth);
        }
        httpSender.setTenantId(properties.getHttpTenantId());
        httpSender.setContentType(loki4jEncoder.getContentType());
        httpSender.setContext((Context)context);
        httpSender.start();
        return httpSender;
    }

    private String formatLabelPatternHandle(LoggerContext context, MicaLoggingProperties.Loki properties) {
        String labelPattern = properties.getFormatLabelPattern();
        Assert.hasText((String)labelPattern, (String)"MicaLoggingProperties mica.logging.loki.format-label-pattern is blank.");
        String labelPatternExtend = properties.getFormatLabelPatternExtend();
        if (StringUtil.isNotBlank((CharSequence)labelPatternExtend)) {
            labelPattern = labelPattern + ',' + labelPatternExtend;
        }
        return labelPattern.replace("${appName}", this.appName).replace("${profile}", this.profile).replace("${HOSTNAME}", context.getProperty("HOSTNAME"));
    }

    private static MicaLoggingProperties.HttpSender getHttpSender(MicaLoggingProperties.Loki properties) {
        MicaLoggingProperties.HttpSender httpSenderProp = properties.getHttpSender();
        if (httpSenderProp != null && httpSenderProp.isAvailable()) {
            log.debug("mica logging use {} HttpSender", (Object)httpSenderProp);
            return httpSenderProp;
        }
        if (httpSenderProp == null) {
            MicaLoggingProperties.HttpSender[] httpSenders;
            for (MicaLoggingProperties.HttpSender httpSender : httpSenders = MicaLoggingProperties.HttpSender.values()) {
                if (!httpSender.isAvailable()) continue;
                log.debug("mica logging use {} HttpSender", (Object)httpSender);
                return httpSender;
            }
            throw new IllegalArgumentException("Not java11 and no okHttp or apache http dependency.");
        }
        throw new NoClassDefFoundError(httpSenderProp.getSenderClass());
    }
}

