/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.logging.loki;

import ch.qos.logback.core.joran.spi.NoAutoStart;
import com.github.loki4j.common.LokiResponse;
import com.github.loki4j.logback.AbstractHttpSender;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;

@NoAutoStart
public class OkHttpSender
extends AbstractHttpSender {
    private OkHttpClient httpClient;
    private MediaType mediaType;
    private byte[] bodyBuffer = new byte[0];

    public void start() {
        super.start();
        this.httpClient = new OkHttpClient();
        this.mediaType = MediaType.get((String)this.contentType);
    }

    public void stop() {
        super.stop();
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
        Util.closeQuietly((Closeable)this.httpClient.cache());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LokiResponse send(ByteBuffer batch) {
        Request.Builder request = new Request.Builder().url(this.getUrl()).addHeader("Content-Type", this.contentType);
        this.tenantId.ifPresent(tenant -> request.addHeader("X-Scope-OrgID", tenant));
        this.basicAuthToken.ifPresent(token -> request.addHeader("Authorization", "Basic " + token));
        if (batch.hasArray()) {
            request.post(RequestBody.create((MediaType)this.mediaType, (byte[])batch.array(), (int)batch.position(), (int)batch.remaining()));
        } else {
            int len = batch.remaining();
            if (len > this.bodyBuffer.length) {
                this.bodyBuffer = new byte[len];
            }
            batch.get(this.bodyBuffer, 0, len);
            request.post(RequestBody.create((MediaType)this.mediaType, (byte[])this.bodyBuffer, (int)0, (int)len));
        }
        Call call = this.httpClient.newCall(request.build());
        try (Response response = call.execute();){
            String body = response.body() != null ? response.body().string() : "";
            LokiResponse lokiResponse = new LokiResponse(response.code(), body);
            return lokiResponse;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while sending batch to Loki", e);
        }
    }
}

