/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.logging.config;

import java.util.HashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class LoggingInitializer
implements EnvironmentPostProcessor,
Ordered {
    public static final String LOGGING_FILE_PATH_KEY = "logging.file.path";
    public static final String LOGGING_FILE_NAME_KEY = "logging.file.name";
    public static final String MICA_LOGGING_PROPERTY_SOURCE_NAME = "micaLoggingPropertySource";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String logBase = environment.getProperty(LOGGING_FILE_PATH_KEY, "logs");
        if (!environment.containsProperty(LOGGING_FILE_NAME_KEY)) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put(LOGGING_FILE_NAME_KEY, logBase + "/${spring.application.name}/" + "all.log");
            MapPropertySource propertySource = new MapPropertySource(MICA_LOGGING_PROPERTY_SOURCE_NAME, map);
            environment.getPropertySources().addLast((PropertySource)propertySource);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

