/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.metrics.sentinel;

import com.alibaba.csp.sentinel.metric.extension.MetricExtension;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class SentinelMetricsExtension
implements MetricExtension {
    public static final String SENTINEL_METRIC_NAME_PREFIX = "sentinel";
    public static final String PASS_REQUESTS_TOTAL = "sentinel.pass.requests.total";
    public static final String BLOCK_REQUESTS_TOTAL = "sentinel.block.requests.total";
    public static final String SUCCESS_REQUESTS_TOTAL = "sentinel.success.requests.total";
    public static final String EXCEPTION_REQUESTS_TOTAL = "sentinel.exception_requests_total";
    public static final String REQUESTS_LATENCY_SECONDS = "sentinel.requests.latency.seconds";
    public static final String CURRENT_THREADS = "sentinel.current.threads";
    public static final String DEFAULT_TAT_NAME = "resource";
    private static final AtomicLong CURRENT_THREAD_COUNT = new AtomicLong(0L);

    public void addPass(String resource, int n, Object ... args) {
        Metrics.counter((String)PASS_REQUESTS_TOTAL, (String[])new String[]{DEFAULT_TAT_NAME, resource}).increment((double)n);
    }

    public void addBlock(String resource, int n, String origin, BlockException ex, Object ... args) {
        Metrics.counter((String)BLOCK_REQUESTS_TOTAL, (String[])new String[]{resource, ex.getClass().getSimpleName(), ex.getRuleLimitApp(), origin}).increment((double)n);
    }

    public void addSuccess(String resource, int n, Object ... args) {
        Metrics.counter((String)SUCCESS_REQUESTS_TOTAL, (String[])new String[]{DEFAULT_TAT_NAME, resource}).increment((double)n);
    }

    public void addException(String resource, int n, Throwable throwable) {
        Metrics.counter((String)EXCEPTION_REQUESTS_TOTAL, (String[])new String[]{DEFAULT_TAT_NAME, resource}).increment((double)n);
    }

    public void addRt(String resource, long rt, Object ... args) {
        Metrics.timer((String)REQUESTS_LATENCY_SECONDS, (String[])new String[]{DEFAULT_TAT_NAME, resource}).record(rt, TimeUnit.MICROSECONDS);
    }

    public void increaseThreadNum(String resource, Object ... args) {
        Tags tags = Tags.of((String)DEFAULT_TAT_NAME, (String)resource);
        Metrics.gauge((String)CURRENT_THREADS, (Iterable)tags, (Object)CURRENT_THREAD_COUNT, AtomicLong::incrementAndGet);
    }

    public void decreaseThreadNum(String resource, Object ... args) {
        Tags tags = Tags.of((String)DEFAULT_TAT_NAME, (String)resource);
        Metrics.gauge((String)CURRENT_THREADS, (Iterable)tags, (Object)CURRENT_THREAD_COUNT, AtomicLong::decrementAndGet);
    }
}

