/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.client;

import java.nio.ByteBuffer;
import net.dreamlu.iot.mqtt.codec.ByteBufferAllocator;
import net.dreamlu.iot.mqtt.codec.DecoderResult;
import net.dreamlu.iot.mqtt.codec.MqttConnAckMessage;
import net.dreamlu.iot.mqtt.codec.MqttDecoder;
import net.dreamlu.iot.mqtt.codec.MqttEncoder;
import net.dreamlu.iot.mqtt.codec.MqttFixedHeader;
import net.dreamlu.iot.mqtt.codec.MqttMessage;
import net.dreamlu.iot.mqtt.codec.MqttMessageType;
import net.dreamlu.iot.mqtt.codec.MqttPubAckMessage;
import net.dreamlu.iot.mqtt.codec.MqttPublishMessage;
import net.dreamlu.iot.mqtt.codec.MqttSubAckMessage;
import net.dreamlu.iot.mqtt.codec.MqttUnsubAckMessage;
import net.dreamlu.iot.mqtt.core.client.IMqttClientProcessor;
import net.dreamlu.iot.mqtt.core.client.MqttClientCreator;
import org.tio.client.intf.ClientAioHandler;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.Packet;

public class MqttClientAioHandler
implements ClientAioHandler {
    private final MqttDecoder mqttDecoder;
    private final MqttEncoder mqttEncoder;
    private final ByteBufferAllocator allocator;
    private final IMqttClientProcessor processor;

    public MqttClientAioHandler(MqttClientCreator mqttClientCreator, IMqttClientProcessor processor) {
        this.mqttDecoder = new MqttDecoder(mqttClientCreator.getMaxBytesInMessage(), mqttClientCreator.getMaxClientIdLength());
        this.mqttEncoder = MqttEncoder.INSTANCE;
        this.allocator = mqttClientCreator.getBufferAllocator();
        this.processor = processor;
    }

    public Packet heartbeatPacket(ChannelContext channelContext) {
        return MqttMessage.PINGREQ;
    }

    public Packet decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext context) throws TioDecodeException {
        return this.mqttDecoder.doDecode(context, buffer, limit, position, readableLength);
    }

    public ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext channelContext) {
        return this.mqttEncoder.doEncode(channelContext, (MqttMessage)packet, this.allocator);
    }

    public void handler(Packet packet, ChannelContext context) {
        MqttMessage message = (MqttMessage)packet;
        DecoderResult decoderResult = message.decoderResult();
        if (decoderResult.isFailure()) {
            this.processor.processDecodeFailure(context, message, decoderResult.getCause());
            return;
        }
        MqttFixedHeader fixedHeader = message.fixedHeader();
        MqttMessageType messageType = fixedHeader.messageType();
        switch (messageType) {
            case CONNACK: {
                this.processor.processConAck(context, (MqttConnAckMessage)message);
                break;
            }
            case SUBACK: {
                this.processor.processSubAck((MqttSubAckMessage)message);
                break;
            }
            case PUBLISH: {
                this.processor.processPublish(context, (MqttPublishMessage)message);
                break;
            }
            case UNSUBACK: {
                this.processor.processUnSubAck((MqttUnsubAckMessage)message);
                break;
            }
            case PUBACK: {
                this.processor.processPubAck((MqttPubAckMessage)message);
                break;
            }
            case PUBREC: {
                this.processor.processPubRec(context, message);
                break;
            }
            case PUBREL: {
                this.processor.processPubRel(context, message);
                break;
            }
            case PUBCOMP: {
                this.processor.processPubComp(message);
                break;
            }
        }
    }
}

