/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.client;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadPoolExecutor;
import net.dreamlu.iot.mqtt.codec.MqttConnectMessage;
import net.dreamlu.iot.mqtt.codec.MqttMessageBuilders;
import net.dreamlu.iot.mqtt.codec.MqttProperties;
import net.dreamlu.iot.mqtt.codec.MqttVersion;
import net.dreamlu.iot.mqtt.core.client.IMqttClientConnectListener;
import net.dreamlu.iot.mqtt.core.client.MqttClientCreator;
import net.dreamlu.iot.mqtt.core.client.MqttWillMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.DefaultClientAioListener;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.utils.hutool.StrUtil;

public class MqttClientAioListener
extends DefaultClientAioListener {
    private static final Logger logger = LoggerFactory.getLogger(MqttClientAioListener.class);
    private final MqttClientCreator clientCreator;
    private final IMqttClientConnectListener connectListener;
    private final ThreadPoolExecutor executor;

    public MqttClientAioListener(MqttClientCreator clientCreator) {
        this.clientCreator = clientCreator;
        this.connectListener = clientCreator.getConnectListener();
        this.executor = clientCreator.getMqttExecutor();
    }

    public void onAfterConnected(ChannelContext context, boolean isConnected, boolean isReconnect) {
        if (isConnected) {
            Boolean result = Tio.send((ChannelContext)context, (Packet)MqttClientAioListener.getConnectMessage(this.clientCreator));
            logger.info("MqttClient reconnect send connect result:{}", (Object)result);
        }
    }

    public void onBeforeClose(ChannelContext channelContext, Throwable throwable, String remark, boolean isRemove) {
        if (this.connectListener == null) {
            return;
        }
        this.executor.submit(() -> {
            try {
                this.connectListener.onDisconnect(channelContext, throwable, remark, isRemove);
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        });
    }

    private static MqttConnectMessage getConnectMessage(MqttClientCreator mqttClientCreator) {
        MqttWillMessage willMessage = mqttClientCreator.getWillMessage();
        MqttVersion version = mqttClientCreator.getVersion();
        int keepAliveSecs = mqttClientCreator.getKeepAliveSecs();
        MqttMessageBuilders.ConnectBuilder builder = MqttMessageBuilders.connect().clientId(mqttClientCreator.getClientId()).username(mqttClientCreator.getUsername()).cleanSession(mqttClientCreator.isCleanSession()).protocolVersion(version).keepAlive(keepAliveSecs > 0 ? keepAliveSecs : 60).willFlag(willMessage != null);
        String password = mqttClientCreator.getPassword();
        if (StrUtil.isNotBlank((CharSequence)password)) {
            builder.password(password.getBytes(StandardCharsets.UTF_8));
        }
        if (willMessage != null) {
            builder.willTopic(willMessage.getTopic()).willMessage(willMessage.getMessage()).willRetain(willMessage.isRetain()).willQoS(willMessage.getQos()).willProperties(willMessage.getWillProperties());
        }
        if (MqttVersion.MQTT_5 == version) {
            MqttProperties properties = mqttClientCreator.getProperties();
            Integer sessionExpiryInterval = mqttClientCreator.getSessionExpiryIntervalSecs();
            if (sessionExpiryInterval != null && sessionExpiryInterval > 0) {
                if (properties == null) {
                    properties = new MqttProperties();
                }
                properties.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SESSION_EXPIRY_INTERVAL, sessionExpiryInterval));
            }
            if (properties != null) {
                builder.properties(properties);
            }
        }
        return builder.build();
    }
}

