/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.client;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.dreamlu.iot.mqtt.codec.MqttMessage;
import net.dreamlu.iot.mqtt.codec.MqttSubscribeMessage;
import net.dreamlu.iot.mqtt.core.client.MqttClientSubscription;
import net.dreamlu.iot.mqtt.core.common.RetryProcessor;
import net.dreamlu.iot.mqtt.core.util.timer.AckService;

final class MqttPendingSubscription {
    private final List<MqttClientSubscription> subscriptionList;
    private final RetryProcessor<MqttSubscribeMessage> retryProcessor = new RetryProcessor();

    MqttPendingSubscription(List<MqttClientSubscription> subscriptionList, MqttSubscribeMessage message) {
        this.subscriptionList = subscriptionList;
        this.retryProcessor.setOriginalMessage(message);
    }

    public List<MqttClientSubscription> getSubscriptionList() {
        return this.subscriptionList;
    }

    protected void startRetransmitTimer(AckService ackService, Consumer<MqttMessage> sendPacket) {
        this.retryProcessor.setHandle((fixedHeader, originalMessage) -> sendPacket.accept((MqttMessage)new MqttSubscribeMessage(fixedHeader, originalMessage.variableHeader(), originalMessage.payload())));
        this.retryProcessor.start(ackService);
    }

    protected void onSubAckReceived() {
        this.retryProcessor.stop();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttPendingSubscription that = (MqttPendingSubscription)o;
        return Objects.equals(this.subscriptionList, that.subscriptionList);
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionList);
    }
}

