/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.client;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import net.dreamlu.iot.mqtt.codec.MqttProperties;
import net.dreamlu.iot.mqtt.codec.MqttQoS;
import net.dreamlu.iot.mqtt.core.util.TopicUtil;

public final class MqttWillMessage {
    private final String topic;
    private final byte[] message;
    private final boolean retain;
    private final MqttQoS qos;
    private final MqttProperties willProperties;

    private MqttWillMessage(String topic, byte[] message, boolean retain, MqttQoS qos, MqttProperties willProperties) {
        this.topic = topic;
        this.message = message;
        this.retain = retain;
        this.qos = qos;
        this.willProperties = willProperties;
    }

    public String getTopic() {
        return this.topic;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public boolean isRetain() {
        return this.retain;
    }

    public MqttQoS getQos() {
        return this.qos;
    }

    public MqttProperties getWillProperties() {
        return this.willProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttWillMessage that = (MqttWillMessage)o;
        return this.retain == that.retain && Objects.equals(this.topic, that.topic) && Arrays.equals(this.message, that.message) && this.qos == that.qos;
    }

    public int hashCode() {
        return Objects.hash(this.topic, Arrays.hashCode(this.message), this.retain, this.qos);
    }

    public String toString() {
        return "MqttWillMessage{topic='" + this.topic + '\'' + ", message='" + Arrays.toString(this.message) + '\'' + ", retain=" + this.retain + ", qos=" + this.qos + '}';
    }

    public static final class Builder {
        private String topic;
        private byte[] message;
        private boolean retain;
        private MqttQoS qos;
        private MqttProperties willProperties;

        public Builder topic(String topic) {
            TopicUtil.validateTopicName(topic);
            this.topic = topic;
            return this;
        }

        public Builder message(byte[] message) {
            this.message = Objects.requireNonNull(message);
            return this;
        }

        public Builder messageText(String message) {
            this.message = Objects.requireNonNull(message).getBytes(StandardCharsets.UTF_8);
            return this;
        }

        public Builder retain(boolean retain) {
            this.retain = retain;
            return this;
        }

        public Builder qos(MqttQoS qos) {
            this.qos = Objects.requireNonNull(qos);
            return this;
        }

        public Builder willProperties(MqttProperties willProperties) {
            this.willProperties = Objects.requireNonNull(willProperties);
            return this;
        }

        public MqttWillMessage build() {
            if (!this.retain && MqttQoS.AT_MOST_ONCE != this.qos) {
                throw new IllegalArgumentException("WillMessage retain is false and QoS must be 0");
            }
            return new MqttWillMessage(this.topic, this.message, this.retain, this.qos, this.willProperties);
        }
    }
}

