/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.common;

import java.util.Objects;
import java.util.function.Consumer;
import net.dreamlu.iot.mqtt.codec.MqttMessage;
import net.dreamlu.iot.mqtt.codec.MqttPublishMessage;
import net.dreamlu.iot.mqtt.core.common.RetryProcessor;
import net.dreamlu.iot.mqtt.core.util.timer.AckService;

public final class MqttPendingQos2Publish {
    private final MqttPublishMessage incomingPublish;
    private final RetryProcessor<MqttMessage> retryProcessor = new RetryProcessor();

    public MqttPendingQos2Publish(MqttPublishMessage incomingPublish, MqttMessage originalMessage) {
        this.incomingPublish = incomingPublish;
        this.retryProcessor.setOriginalMessage(originalMessage);
    }

    public MqttPublishMessage getIncomingPublish() {
        return this.incomingPublish;
    }

    public void startPubRecRetransmitTimer(AckService ackService, Consumer<MqttMessage> sendPacket) {
        this.retryProcessor.setHandle((fixedHeader, originalMessage) -> sendPacket.accept(new MqttMessage(fixedHeader, originalMessage.variableHeader())));
        this.retryProcessor.start(ackService);
    }

    public void onPubRelReceived() {
        this.retryProcessor.stop();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttPendingQos2Publish that = (MqttPendingQos2Publish)o;
        return Objects.equals(this.incomingPublish, that.incomingPublish);
    }

    public int hashCode() {
        return Objects.hash(this.incomingPublish);
    }
}

