/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.server;

import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import net.dreamlu.iot.mqtt.codec.ByteBufferAllocator;
import net.dreamlu.iot.mqtt.core.server.MqttServer;
import net.dreamlu.iot.mqtt.core.server.MqttServerAioHandler;
import net.dreamlu.iot.mqtt.core.server.MqttServerAioListener;
import net.dreamlu.iot.mqtt.core.server.auth.IMqttServerAuthHandler;
import net.dreamlu.iot.mqtt.core.server.auth.IMqttServerPublishPermission;
import net.dreamlu.iot.mqtt.core.server.auth.IMqttServerSubscribeValidator;
import net.dreamlu.iot.mqtt.core.server.auth.IMqttServerUniqueIdService;
import net.dreamlu.iot.mqtt.core.server.broker.DefaultMqttBrokerDispatcher;
import net.dreamlu.iot.mqtt.core.server.dispatcher.AbstractMqttMessageDispatcher;
import net.dreamlu.iot.mqtt.core.server.dispatcher.IMqttMessageDispatcher;
import net.dreamlu.iot.mqtt.core.server.event.IMqttConnectStatusListener;
import net.dreamlu.iot.mqtt.core.server.event.IMqttMessageListener;
import net.dreamlu.iot.mqtt.core.server.event.IMqttSessionListener;
import net.dreamlu.iot.mqtt.core.server.http.core.MqttWebServer;
import net.dreamlu.iot.mqtt.core.server.session.IMqttSessionManager;
import net.dreamlu.iot.mqtt.core.server.session.InMemoryMqttSessionManager;
import net.dreamlu.iot.mqtt.core.server.store.IMqttMessageStore;
import net.dreamlu.iot.mqtt.core.server.store.InMemoryMqttMessageStore;
import net.dreamlu.iot.mqtt.core.server.support.DefaultMqttConnectStatusListener;
import net.dreamlu.iot.mqtt.core.server.support.DefaultMqttServerAuthHandler;
import net.dreamlu.iot.mqtt.core.server.support.DefaultMqttServerProcessor;
import net.dreamlu.iot.mqtt.core.server.support.DefaultMqttServerUniqueIdServiceImpl;
import net.dreamlu.iot.mqtt.core.util.ThreadUtil;
import net.dreamlu.iot.mqtt.core.util.timer.DefaultAckService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.TioConfig;
import org.tio.core.ssl.SslConfig;
import org.tio.core.stat.IpStatListener;
import org.tio.server.ServerTioConfig;
import org.tio.server.TioServer;
import org.tio.server.intf.ServerAioHandler;
import org.tio.server.intf.ServerAioListener;
import org.tio.utils.Threads;
import org.tio.utils.hutool.StrUtil;

public class MqttServerCreator {
    private static final Logger logger = LoggerFactory.getLogger(MqttServerCreator.class);
    private String name = "Mica-Mqtt-Server";
    private String ip;
    private int port = 1883;
    private Long heartbeatTimeout;
    private float keepaliveBackoff = 0.75f;
    private int readBufferSize = 8192;
    private int maxBytesInMessage = 0xA00000;
    private ByteBufferAllocator bufferAllocator = ByteBufferAllocator.HEAP;
    private SslConfig sslConfig;
    private IpStatListener ipStatListener;
    private IMqttServerAuthHandler authHandler;
    private IMqttServerUniqueIdService uniqueIdService;
    private IMqttServerSubscribeValidator subscribeValidator;
    private IMqttServerPublishPermission publishPermission;
    private IMqttMessageDispatcher messageDispatcher;
    private IMqttMessageStore messageStore;
    private IMqttSessionManager sessionManager;
    private IMqttSessionListener sessionListener;
    private IMqttMessageListener messageListener;
    private IMqttConnectStatusListener connectStatusListener;
    private boolean debug = false;
    private int maxClientIdLength = 23;
    private int webPort = 8083;
    private boolean websocketEnable = true;
    private boolean httpEnable = false;
    private String httpBasicUsername;
    private String httpBasicPassword;
    private String nodeName;
    private boolean useQueueSend = true;
    private boolean useQueueDecode = false;
    private boolean statEnable = false;
    private Consumer<TioConfig> tioConfigCustomize;

    public String getName() {
        return this.name;
    }

    public MqttServerCreator name(String name) {
        this.name = name;
        return this;
    }

    public String getIp() {
        return this.ip;
    }

    public MqttServerCreator ip(String ip) {
        this.ip = ip;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public MqttServerCreator port(int port) {
        this.port = port;
        return this;
    }

    public Long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public MqttServerCreator heartbeatTimeout(Long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
        return this;
    }

    public float getKeepaliveBackoff() {
        return this.keepaliveBackoff;
    }

    public MqttServerCreator keepaliveBackoff(float keepaliveBackoff) {
        if ((double)keepaliveBackoff <= 0.5) {
            throw new IllegalArgumentException("keepalive backoff must greater than 0.5");
        }
        this.keepaliveBackoff = keepaliveBackoff;
        return this;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public MqttServerCreator readBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    public int getMaxBytesInMessage() {
        return this.maxBytesInMessage;
    }

    public MqttServerCreator maxBytesInMessage(int maxBytesInMessage) {
        if (maxBytesInMessage < 1) {
            throw new IllegalArgumentException("maxBytesInMessage must be greater than 0.");
        }
        this.maxBytesInMessage = maxBytesInMessage;
        return this;
    }

    public ByteBufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    public MqttServerCreator bufferAllocator(ByteBufferAllocator bufferAllocator) {
        this.bufferAllocator = bufferAllocator;
        return this;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public MqttServerCreator useSsl(InputStream keyStoreInputStream, InputStream trustStoreInputStream, String pwd) {
        try {
            this.sslConfig = SslConfig.forServer((InputStream)keyStoreInputStream, (InputStream)trustStoreInputStream, (String)pwd);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public MqttServerCreator useSsl(String keyStoreFile, String trustStoreFile, String pwd) {
        try {
            this.sslConfig = SslConfig.forServer((String)keyStoreFile, (String)trustStoreFile, (String)pwd);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public IpStatListener getIpStatListener() {
        return this.ipStatListener;
    }

    public MqttServerCreator ipStatListener(IpStatListener ipStatListener) {
        this.ipStatListener = ipStatListener;
        return this;
    }

    public IMqttServerAuthHandler getAuthHandler() {
        return this.authHandler;
    }

    public MqttServerCreator authHandler(IMqttServerAuthHandler authHandler) {
        this.authHandler = authHandler;
        return this;
    }

    public MqttServerCreator usernamePassword(String username, String password) {
        return this.authHandler(new DefaultMqttServerAuthHandler(username, password));
    }

    public IMqttServerUniqueIdService getUniqueIdService() {
        return this.uniqueIdService;
    }

    public MqttServerCreator uniqueIdService(IMqttServerUniqueIdService uniqueIdService) {
        this.uniqueIdService = uniqueIdService;
        return this;
    }

    public IMqttServerSubscribeValidator getSubscribeValidator() {
        return this.subscribeValidator;
    }

    public MqttServerCreator subscribeValidator(IMqttServerSubscribeValidator subscribeValidator) {
        this.subscribeValidator = subscribeValidator;
        return this;
    }

    public IMqttServerPublishPermission getPublishPermission() {
        return this.publishPermission;
    }

    public MqttServerCreator publishPermission(IMqttServerPublishPermission publishPermission) {
        this.publishPermission = publishPermission;
        return this;
    }

    public IMqttMessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    public MqttServerCreator messageDispatcher(IMqttMessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
        return this;
    }

    public IMqttMessageStore getMessageStore() {
        return this.messageStore;
    }

    public MqttServerCreator messageStore(IMqttMessageStore messageStore) {
        this.messageStore = messageStore;
        return this;
    }

    public IMqttSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public MqttServerCreator sessionManager(IMqttSessionManager sessionManager) {
        this.sessionManager = sessionManager;
        return this;
    }

    public IMqttSessionListener getSessionListener() {
        return this.sessionListener;
    }

    public MqttServerCreator sessionListener(IMqttSessionListener sessionListener) {
        this.sessionListener = sessionListener;
        return this;
    }

    public IMqttMessageListener getMessageListener() {
        return this.messageListener;
    }

    public MqttServerCreator messageListener(IMqttMessageListener messageListener) {
        this.messageListener = messageListener;
        return this;
    }

    public IMqttConnectStatusListener getConnectStatusListener() {
        return this.connectStatusListener;
    }

    public MqttServerCreator connectStatusListener(IMqttConnectStatusListener connectStatusListener) {
        this.connectStatusListener = connectStatusListener;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public MqttServerCreator debug() {
        this.debug = true;
        return this;
    }

    public int getMaxClientIdLength() {
        return this.maxClientIdLength;
    }

    public MqttServerCreator maxClientIdLength(int maxClientIdLength) {
        this.maxClientIdLength = maxClientIdLength;
        return this;
    }

    public int getWebPort() {
        return this.webPort;
    }

    public MqttServerCreator webPort(int webPort) {
        this.webPort = webPort;
        return this;
    }

    public boolean isWebsocketEnable() {
        return this.websocketEnable;
    }

    public MqttServerCreator websocketEnable(boolean websocketEnable) {
        this.websocketEnable = websocketEnable;
        return this;
    }

    public boolean isHttpEnable() {
        return this.httpEnable;
    }

    public MqttServerCreator httpEnable(boolean httpEnable) {
        this.httpEnable = httpEnable;
        return this;
    }

    public String getHttpBasicUsername() {
        return this.httpBasicUsername;
    }

    public MqttServerCreator httpBasicAuth(String username, String password) {
        if (StrUtil.isBlank((CharSequence)username) || StrUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("Mqtt http basic auth username or password is blank.");
        }
        this.httpBasicUsername = username;
        this.httpBasicPassword = password;
        return this;
    }

    public String getHttpBasicPassword() {
        return this.httpBasicPassword;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public MqttServerCreator nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    public boolean isUseQueueSend() {
        return this.useQueueSend;
    }

    public MqttServerCreator useQueueSend(boolean useQueueSend) {
        this.useQueueSend = useQueueSend;
        return this;
    }

    public boolean isUseQueueDecode() {
        return this.useQueueDecode;
    }

    public MqttServerCreator useQueueDecode(boolean useQueueDecode) {
        this.useQueueDecode = useQueueDecode;
        return this;
    }

    public boolean isStatEnable() {
        return this.statEnable;
    }

    public MqttServerCreator statEnable() {
        return this.statEnable(true);
    }

    public MqttServerCreator statEnable(boolean enable) {
        this.statEnable = enable;
        return this;
    }

    public MqttServerCreator tioConfigCustomize(Consumer<TioConfig> tioConfigCustomize) {
        this.tioConfigCustomize = tioConfigCustomize;
        return this;
    }

    public MqttServer build() {
        if (StrUtil.isBlank((CharSequence)this.nodeName)) {
            this.nodeName = ManagementFactory.getRuntimeMXBean().getName() + ':' + this.port;
        }
        if (this.uniqueIdService == null) {
            this.uniqueIdService = new DefaultMqttServerUniqueIdServiceImpl();
        }
        if (this.messageDispatcher == null) {
            this.messageDispatcher = new DefaultMqttBrokerDispatcher();
        }
        if (this.sessionManager == null) {
            this.sessionManager = new InMemoryMqttSessionManager();
        }
        if (this.messageStore == null) {
            this.messageStore = new InMemoryMqttMessageStore();
        }
        if (this.connectStatusListener == null) {
            this.connectStatusListener = new DefaultMqttConnectStatusListener();
        }
        ThreadPoolExecutor mqttExecutor = ThreadUtil.getMqttExecutor(Threads.MAX_POOL_SIZE_FOR_TIO);
        DefaultAckService ackService = new DefaultAckService();
        DefaultMqttServerProcessor serverProcessor = new DefaultMqttServerProcessor(this, ackService, mqttExecutor);
        MqttServerAioHandler handler = new MqttServerAioHandler(this, serverProcessor);
        MqttServerAioListener listener = new MqttServerAioListener(this, mqttExecutor);
        ServerTioConfig tioConfig = new ServerTioConfig(this.name, (ServerAioHandler)handler, (ServerAioListener)listener);
        tioConfig.setUseQueueDecode(this.useQueueDecode);
        tioConfig.setUseQueueSend(this.useQueueSend);
        if (this.readBufferSize > 0) {
            tioConfig.setReadBufferSize(this.readBufferSize);
        }
        tioConfig.statOn = this.statEnable;
        if (this.heartbeatTimeout != null) {
            tioConfig.setHeartbeatTimeout(this.heartbeatTimeout.longValue());
        }
        if (this.ipStatListener != null) {
            tioConfig.setIpStatListener(this.ipStatListener);
        }
        if (this.sslConfig != null) {
            tioConfig.setSslConfig(this.sslConfig);
        }
        if (this.debug) {
            tioConfig.debug = true;
        }
        if (this.tioConfigCustomize != null) {
            this.tioConfigCustomize.accept((TioConfig)tioConfig);
        }
        TioServer tioServer = new TioServer(tioConfig);
        tioServer.setCheckLastVersion(false);
        logger.info("Mica mqtt http api enable:{} websocket enable:{}", (Object)this.httpEnable, (Object)this.websocketEnable);
        MqttWebServer webServer = this.httpEnable || this.websocketEnable ? MqttWebServer.config(this, tioConfig) : null;
        MqttServer mqttServer = new MqttServer(tioServer, webServer, this, ackService);
        if (this.messageDispatcher instanceof AbstractMqttMessageDispatcher) {
            ((AbstractMqttMessageDispatcher)this.messageDispatcher).config(mqttServer);
        }
        return mqttServer;
    }

    public MqttServer start() {
        MqttServer mqttServer = this.build();
        mqttServer.start();
        return mqttServer;
    }
}

