/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.server.dispatcher;

import java.util.Objects;
import net.dreamlu.iot.mqtt.core.server.MqttServer;
import net.dreamlu.iot.mqtt.core.server.dispatcher.IMqttMessageDispatcher;
import net.dreamlu.iot.mqtt.core.server.enums.MessageType;
import net.dreamlu.iot.mqtt.core.server.model.Message;
import net.dreamlu.iot.mqtt.core.server.session.IMqttSessionManager;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;

public abstract class AbstractMqttMessageDispatcher
implements IMqttMessageDispatcher {
    protected MqttServer mqttServer;
    protected IMqttSessionManager sessionManager;

    public void config(MqttServer mqttServer) {
        this.mqttServer = mqttServer;
        this.sessionManager = mqttServer.getServerCreator().getSessionManager();
    }

    public abstract void sendAll(Message var1);

    @Override
    public boolean send(Message message) {
        String clientId;
        ChannelContext context;
        Objects.requireNonNull(this.mqttServer, "MqttServer require not Null.");
        MessageType messageType = message.getMessageType();
        if (MessageType.SUBSCRIBE == messageType) {
            this.sessionManager.addSubscribe(message.getTopic(), message.getFromClientId(), message.getQos());
        } else if (MessageType.UNSUBSCRIBE == messageType) {
            this.sessionManager.removeSubscribe(message.getTopic(), message.getFromClientId());
        } else if (MessageType.UP_STREAM == messageType) {
            this.mqttServer.sendToClient(message.getTopic(), message);
        } else if (MessageType.DOWN_STREAM == messageType) {
            this.mqttServer.sendToClient(message.getTopic(), message);
        } else if (MessageType.DISCONNECT == messageType && (context = this.mqttServer.getChannelContext(clientId = message.getClientId())) != null) {
            Tio.remove((ChannelContext)context, (String)("Mqtt server delete clients:" + clientId));
        }
        this.sendAll(message);
        return true;
    }
}

