/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.server.session;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.dreamlu.iot.mqtt.core.common.MqttPendingPublish;
import net.dreamlu.iot.mqtt.core.common.MqttPendingQos2Publish;
import net.dreamlu.iot.mqtt.core.server.model.Subscribe;
import net.dreamlu.iot.mqtt.core.server.session.IMqttSessionManager;
import net.dreamlu.iot.mqtt.core.util.TopicUtil;
import net.dreamlu.iot.mqtt.core.util.collection.IntObjectHashMap;
import net.dreamlu.iot.mqtt.core.util.collection.IntObjectMap;

public class InMemoryMqttSessionManager
implements IMqttSessionManager {
    private final ConcurrentMap<String, AtomicInteger> messageIdStore = new ConcurrentHashMap<String, AtomicInteger>();
    private final ConcurrentMap<String, ConcurrentMap<String, Integer>> subscribeStore = new ConcurrentHashMap<String, ConcurrentMap<String, Integer>>();
    private final ConcurrentMap<String, IntObjectMap<MqttPendingPublish>> pendingPublishStore = new ConcurrentHashMap<String, IntObjectMap<MqttPendingPublish>>();
    private final ConcurrentMap<String, IntObjectMap<MqttPendingQos2Publish>> pendingQos2PublishStore = new ConcurrentHashMap<String, IntObjectMap<MqttPendingQos2Publish>>();

    @Override
    public void addSubscribe(String topicFilter, String clientId, int mqttQoS) {
        Map data = this.subscribeStore.computeIfAbsent(topicFilter, key -> new ConcurrentHashMap(16));
        Integer existingQos = (Integer)data.get(clientId);
        if (existingQos == null || existingQos < mqttQoS) {
            data.put(clientId, mqttQoS);
        }
    }

    @Override
    public void removeSubscribe(String topicFilter, String clientId) {
        ConcurrentMap map = (ConcurrentMap)this.subscribeStore.get(topicFilter);
        if (map == null) {
            return;
        }
        map.remove(clientId);
    }

    public void removeSubscribe(String clientId) {
        this.subscribeStore.forEach((key, value) -> {
            Integer cfr_ignored_0 = (Integer)value.remove(clientId);
        });
    }

    @Override
    public Integer searchSubscribe(String topicName, String clientId) {
        Integer qos;
        ConcurrentMap subscribeData = (ConcurrentMap)this.subscribeStore.get(topicName);
        if (subscribeData != null && !subscribeData.isEmpty() && (qos = (Integer)subscribeData.get(clientId)) != null) {
            return qos;
        }
        Integer qosValue = null;
        Set topicFilterSet = this.subscribeStore.keySet();
        for (String topicFilter : topicFilterSet) {
            Integer mqttQoS;
            ConcurrentMap data;
            if (!TopicUtil.match(topicFilter, topicName) || (data = (ConcurrentMap)this.subscribeStore.get(topicFilter)) == null || data.isEmpty() || (mqttQoS = (Integer)data.get(clientId)) == null) continue;
            if (qosValue == null) {
                qosValue = mqttQoS;
                continue;
            }
            qosValue = Math.min(qosValue, mqttQoS);
        }
        return qosValue;
    }

    @Override
    public List<Subscribe> searchSubscribe(String topicName) {
        HashMap<String, Integer> subscribeMap = new HashMap<String, Integer>(32);
        Set topicFilterSet = this.subscribeStore.keySet();
        for (String topicFilter : topicFilterSet) {
            ConcurrentMap data;
            if (!TopicUtil.match(topicFilter, topicName) || (data = (ConcurrentMap)this.subscribeStore.get(topicFilter)) == null || data.isEmpty()) continue;
            data.forEach((clientId, qos) -> subscribeMap.merge((String)clientId, (Integer)qos, Math::min));
        }
        ArrayList<Subscribe> subscribeList = new ArrayList<Subscribe>();
        subscribeMap.forEach((clientId, qos) -> subscribeList.add(new Subscribe(clientId, qos.intValue())));
        subscribeMap.clear();
        return subscribeList;
    }

    @Override
    public List<Subscribe> getSubscriptions(String clientId) {
        ArrayList<Subscribe> subscribeList = new ArrayList<Subscribe>();
        Set entrySet = this.subscribeStore.entrySet();
        for (Map.Entry mapEntry : entrySet) {
            Integer qos;
            ConcurrentMap mapEntryValue = (ConcurrentMap)mapEntry.getValue();
            if (mapEntryValue == null || mapEntryValue.isEmpty() || (qos = (Integer)mapEntryValue.get(clientId)) == null) continue;
            String topicFilter = (String)mapEntry.getKey();
            subscribeList.add(new Subscribe(topicFilter, clientId, qos.intValue()));
        }
        return subscribeList;
    }

    @Override
    public void addPendingPublish(String clientId, int messageId, MqttPendingPublish pendingPublish) {
        Map data = this.pendingPublishStore.computeIfAbsent(clientId, key -> new IntObjectHashMap(16));
        data.put(messageId, pendingPublish);
    }

    @Override
    public MqttPendingPublish getPendingPublish(String clientId, int messageId) {
        Map data = (Map)this.pendingPublishStore.get(clientId);
        if (data == null) {
            return null;
        }
        return (MqttPendingPublish)data.get(messageId);
    }

    @Override
    public void removePendingPublish(String clientId, int messageId) {
        Map data = (Map)this.pendingPublishStore.get(clientId);
        if (data != null) {
            data.remove(messageId);
        }
    }

    @Override
    public void addPendingQos2Publish(String clientId, int messageId, MqttPendingQos2Publish pendingQos2Publish) {
        Map data = this.pendingQos2PublishStore.computeIfAbsent(clientId, key -> new IntObjectHashMap());
        data.put(messageId, pendingQos2Publish);
    }

    @Override
    public MqttPendingQos2Publish getPendingQos2Publish(String clientId, int messageId) {
        Map data = (Map)this.pendingQos2PublishStore.get(clientId);
        if (data == null) {
            return null;
        }
        return (MqttPendingQos2Publish)data.get(messageId);
    }

    @Override
    public void removePendingQos2Publish(String clientId, int messageId) {
        Map data = (Map)this.pendingQos2PublishStore.get(clientId);
        if (data != null) {
            data.remove(messageId);
        }
    }

    @Override
    public int getMessageId(String clientId) {
        AtomicInteger value = this.messageIdStore.computeIfAbsent(clientId, key -> new AtomicInteger(1));
        value.compareAndSet(65535, 1);
        return value.getAndIncrement();
    }

    @Override
    public boolean hasSession(String clientId) {
        return this.pendingQos2PublishStore.containsKey(clientId) || this.pendingPublishStore.containsKey(clientId) || this.messageIdStore.containsKey(clientId) || this.subscribeStore.values().stream().anyMatch(data -> data.containsKey(clientId));
    }

    @Override
    public boolean expire(String clientId, int sessionExpirySeconds) {
        return false;
    }

    @Override
    public boolean active(String clientId) {
        return false;
    }

    @Override
    public void remove(String clientId) {
        this.removeSubscribe(clientId);
        this.pendingPublishStore.remove(clientId);
        this.pendingQos2PublishStore.remove(clientId);
        this.messageIdStore.remove(clientId);
    }

    @Override
    public void clean() {
        this.subscribeStore.clear();
        this.pendingPublishStore.clear();
        this.pendingQos2PublishStore.clear();
        this.messageIdStore.clear();
    }
}

