/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.server.store;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.dreamlu.iot.mqtt.core.server.model.Message;
import net.dreamlu.iot.mqtt.core.server.store.IMqttMessageStore;
import net.dreamlu.iot.mqtt.core.util.TopicUtil;

public class InMemoryMqttMessageStore
implements IMqttMessageStore {
    private final ConcurrentMap<String, Message> willStore = new ConcurrentHashMap<String, Message>();
    private final ConcurrentMap<String, Message> retainStore = new ConcurrentHashMap<String, Message>();

    @Override
    public boolean addWillMessage(String clientId, Message message) {
        this.willStore.put(clientId, message);
        return true;
    }

    @Override
    public boolean clearWillMessage(String clientId) {
        this.willStore.remove(clientId);
        return true;
    }

    @Override
    public Message getWillMessage(String clientId) {
        return (Message)this.willStore.get(clientId);
    }

    @Override
    public boolean addRetainMessage(String topic, Message message) {
        this.retainStore.put(topic, message);
        return true;
    }

    @Override
    public boolean clearRetainMessage(String topic) {
        this.retainStore.remove(topic);
        return true;
    }

    @Override
    public List<Message> getRetainMessage(String topicFilter) {
        ArrayList<Message> retainMessageList = new ArrayList<Message>();
        this.retainStore.forEach((topic, message) -> {
            if (TopicUtil.match(topicFilter, topic)) {
                retainMessageList.add((Message)message);
            }
        });
        return retainMessageList;
    }
}

