/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.util;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import net.dreamlu.iot.mqtt.core.util.HexUtil;
import org.tio.utils.hutool.StrUtil;

public enum PayloadEncode {
    plain{

        @Override
        public String encode(byte[] data) {
            return new String(data, StandardCharsets.UTF_8);
        }

        @Override
        public byte[] decode(String data) {
            return data.getBytes(StandardCharsets.UTF_8);
        }
    }
    ,
    hex{

        @Override
        public String encode(byte[] data) {
            return HexUtil.encodeToString(data);
        }

        @Override
        public byte[] decode(String data) {
            return HexUtil.decode(data);
        }
    }
    ,
    base64{

        @Override
        public String encode(byte[] data) {
            return Base64.getEncoder().encodeToString(data);
        }

        @Override
        public byte[] decode(String data) {
            return Base64.getDecoder().decode(data);
        }
    };


    public abstract String encode(byte[] var1);

    public abstract byte[] decode(String var1);

    public static byte[] decode(String data, String encoding) {
        return PayloadEncode.getEncode(encoding).decode(data);
    }

    public static PayloadEncode getEncode(String encoding) {
        PayloadEncode[] values;
        if (StrUtil.isBlank((CharSequence)encoding)) {
            return plain;
        }
        for (PayloadEncode encode : values = PayloadEncode.values()) {
            if (!encode.name().equalsIgnoreCase(encoding)) continue;
            return encode;
        }
        return plain;
    }
}

