/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.util.timer;

import net.dreamlu.iot.mqtt.core.util.timer.AckService;
import net.dreamlu.iot.mqtt.core.util.timer.AckTimerTask;
import net.dreamlu.iot.mqtt.core.util.timer.SystemTimer;
import net.dreamlu.iot.mqtt.core.util.timer.TimingWheelThread;

public class DefaultAckService
implements AckService {
    private final SystemTimer systemTimer;
    private final TimingWheelThread timingWheelThread;

    public DefaultAckService() {
        this(new SystemTimer(1000L, 60, "AckServiceExecutor"));
    }

    public DefaultAckService(SystemTimer systemTimer) {
        this(systemTimer, new TimingWheelThread(systemTimer));
    }

    public DefaultAckService(SystemTimer systemTimer, TimingWheelThread timingWheelThread) {
        this.systemTimer = systemTimer;
        this.timingWheelThread = timingWheelThread;
    }

    @Override
    public AckTimerTask addTask(Runnable command, int maxRetryCount, int retryIntervalSecs) {
        AckTimerTask ackTimerTask = new AckTimerTask(this.systemTimer, command, maxRetryCount, retryIntervalSecs);
        this.systemTimer.add(ackTimerTask);
        return ackTimerTask;
    }

    @Override
    public void start() {
        this.timingWheelThread.start();
    }

    @Override
    public void stop() {
        this.timingWheelThread.shutdown();
        this.systemTimer.shutdown();
    }
}

