/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.util.timer;

import net.dreamlu.iot.mqtt.core.util.timer.TimerTask;
import net.dreamlu.iot.mqtt.core.util.timer.TimerTaskList;

public class TimerTaskEntry
implements Comparable<TimerTaskEntry> {
    private volatile TimerTaskList list;
    public TimerTaskEntry next;
    public TimerTaskEntry prev;
    private final TimerTask timerTask;
    private final long expirationMs;

    public TimerTaskEntry(TimerTask timerTask, long expirationMs) {
        if (timerTask != null) {
            timerTask.setTimerTaskEntry(this);
        }
        this.timerTask = timerTask;
        this.expirationMs = expirationMs;
    }

    public boolean cancelled() {
        return this.timerTask.getTimerTaskEntry() != this;
    }

    public void remove() {
        TimerTaskList currentList = this.list;
        while (currentList != null) {
            currentList.remove(this);
            currentList = this.list;
        }
    }

    @Override
    public int compareTo(TimerTaskEntry that) {
        if (that == null) {
            throw new NullPointerException("TimerTaskEntry is null");
        }
        return Long.compare(this.expirationMs, that.expirationMs);
    }

    public long getExpirationMs() {
        return this.expirationMs;
    }

    public TimerTask getTimerTask() {
        return this.timerTask;
    }

    public TimerTaskList getList() {
        return this.list;
    }

    public void setList(TimerTaskList list) {
        this.list = list;
    }
}

