/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.util.timer;

import java.util.concurrent.CountDownLatch;
import net.dreamlu.iot.mqtt.core.util.timer.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimingWheelThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(TimingWheelThread.class);
    private final Timer timer;
    private final long workTimeoutMs;
    private final CountDownLatch shutdownInitiated;
    private final CountDownLatch shutdownComplete;
    private volatile boolean isStarted = false;

    public TimingWheelThread(Timer timer) {
        this(timer, 200L);
    }

    public TimingWheelThread(Timer timer, long workTimeoutMs) {
        this.timer = timer;
        this.workTimeoutMs = workTimeoutMs;
        this.shutdownInitiated = new CountDownLatch(1);
        this.shutdownComplete = new CountDownLatch(1);
        this.setDaemon(false);
    }

    public boolean isShutdownInitiated() {
        return this.shutdownInitiated.getCount() == 0L;
    }

    public boolean isRunning() {
        return !this.isShutdownInitiated();
    }

    @Override
    public void run() {
        this.isStarted = true;
        log.info("Starting");
        try {
            while (this.isRunning()) {
                this.timer.advanceClock(this.workTimeoutMs);
            }
        }
        catch (Exception e) {
            if (this.isRunning()) {
                log.error("Error due to", (Throwable)e);
            }
        }
        finally {
            this.shutdownComplete.countDown();
        }
        log.info("Stopped");
    }

    public void shutdown() {
        this.initiateShutdown();
        this.awaitShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateShutdown() {
        TimingWheelThread timingWheelThread = this;
        synchronized (timingWheelThread) {
            if (this.isRunning()) {
                this.shutdownInitiated.countDown();
            }
        }
    }

    private void awaitShutdown() {
        if (!this.isShutdownInitiated()) {
            throw new IllegalStateException("initiateShutdown() was not called before awaitShutdown()");
        }
        if (this.isStarted) {
            try {
                this.shutdownComplete.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

