/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.dreamlu.iot.mqtt.codec.MqttQoS;
import net.dreamlu.iot.mqtt.core.client.IMqttClientMessageListener;
import net.dreamlu.iot.mqtt.core.client.IMqttClientSession;
import net.dreamlu.iot.mqtt.core.client.MqttClientSubscription;
import net.dreamlu.iot.mqtt.core.client.MqttPendingSubscription;
import net.dreamlu.iot.mqtt.core.client.MqttPendingUnSubscription;
import net.dreamlu.iot.mqtt.core.common.MqttPendingPublish;
import net.dreamlu.iot.mqtt.core.common.MqttPendingQos2Publish;
import net.dreamlu.iot.mqtt.core.util.collection.IntObjectHashMap;
import net.dreamlu.iot.mqtt.core.util.collection.IntObjectMap;
import net.dreamlu.iot.mqtt.core.util.collection.MultiValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultMqttClientSession
implements IMqttClientSession {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMqttClientSession.class);
    private final MultiValueMap<String, MqttClientSubscription> subscriptions = new MultiValueMap();
    private final IntObjectMap<MqttPendingSubscription> pendingSubscriptions = new IntObjectHashMap<MqttPendingSubscription>();
    private final IntObjectMap<MqttPendingUnSubscription> pendingUnSubscriptions = new IntObjectHashMap<MqttPendingUnSubscription>();
    private final IntObjectMap<MqttPendingPublish> pendingPublishData = new IntObjectHashMap<MqttPendingPublish>();
    private final IntObjectMap<MqttPendingQos2Publish> pendingQos2PublishData = new IntObjectHashMap<MqttPendingQos2Publish>();

    @Override
    public void addPaddingSubscribe(int messageId, MqttPendingSubscription pendingSubscription) {
        this.pendingSubscriptions.put(messageId, pendingSubscription);
    }

    @Override
    public MqttPendingSubscription getPaddingSubscribe(int messageId) {
        return this.pendingSubscriptions.get(messageId);
    }

    @Override
    public void removePaddingSubscribes(List<String> topicFilters) {
        HashSet needToRemove = new HashSet();
        this.pendingSubscriptions.forEach((messageId, pendingSubscription) -> {
            List<MqttClientSubscription> subscriptionList = pendingSubscription.getSubscriptionList();
            if (subscriptionList != null) {
                subscriptionList.removeIf(subscription -> topicFilters.contains(subscription.getTopicFilter()));
            }
            if (subscriptionList == null || subscriptionList.isEmpty()) {
                pendingSubscription.onSubAckReceived();
                needToRemove.add(messageId);
            }
        });
        needToRemove.forEach(this.pendingSubscriptions::remove);
    }

    @Override
    public MqttPendingSubscription removePaddingSubscribe(int messageId) {
        return this.pendingSubscriptions.remove(messageId);
    }

    @Override
    public void addSubscriptionList(List<MqttClientSubscription> subscriptionList) {
        for (MqttClientSubscription subscription : subscriptionList) {
            this.subscriptions.add(subscription.getTopicFilter(), subscription);
        }
    }

    @Override
    public boolean isSubscribed(MqttClientSubscription clientSubscription) {
        String topicFilter = clientSubscription.getTopicFilter();
        Object subscriptionSet = this.subscriptions.get(topicFilter);
        if (subscriptionSet == null || subscriptionSet.isEmpty()) {
            return false;
        }
        MqttQoS mqttQoS = clientSubscription.getMqttQoS();
        IMqttClientMessageListener listener = clientSubscription.getListener();
        Iterator iterator = subscriptionSet.iterator();
        while (iterator.hasNext()) {
            MqttClientSubscription subscription = (MqttClientSubscription)iterator.next();
            if (clientSubscription.equals(subscription)) {
                logger.error("MQTT Topic:{} mqttQoS:{} listener:{} duplicate subscription.", new Object[]{topicFilter, mqttQoS, listener});
                return true;
            }
            MqttQoS subQos = subscription.getMqttQoS();
            IMqttClientMessageListener subListener = subscription.getListener();
            if (subQos.value() < mqttQoS.value()) continue;
            if (subListener != listener) {
                this.subscriptions.add(topicFilter, clientSubscription);
                logger.warn("MQTT Topic:{} mqttQoS:{} listener:{} has a higher level qos, added directly.", new Object[]{topicFilter, mqttQoS, listener});
            } else {
                logger.error("MQTT Topic:{} mqttQoS:{} listener:{} has a higher level qos, duplicate subscription.", new Object[]{topicFilter, mqttQoS, listener});
            }
            return true;
        }
        return false;
    }

    @Override
    public List<MqttClientSubscription> getAndCleanSubscription() {
        ArrayList<MqttClientSubscription> subscriptionList = new ArrayList<MqttClientSubscription>();
        for (Set<MqttClientSubscription> mqttSubscriptions : this.subscriptions.values()) {
            subscriptionList.addAll(mqttSubscriptions);
        }
        List<MqttClientSubscription> data = Collections.unmodifiableList(subscriptionList);
        this.subscriptions.clear();
        return data;
    }

    @Override
    public List<MqttClientSubscription> getMatchedSubscription(String topicName) {
        ArrayList<MqttClientSubscription> subscriptionList = new ArrayList<MqttClientSubscription>();
        for (Set<MqttClientSubscription> mqttSubscriptions : this.subscriptions.values()) {
            for (MqttClientSubscription subscription : mqttSubscriptions) {
                if (!subscription.matches(topicName)) continue;
                subscriptionList.add(subscription);
            }
        }
        return Collections.unmodifiableList(subscriptionList);
    }

    @Override
    public void removeSubscriptions(List<String> topicFilters) {
        topicFilters.forEach(this.subscriptions::remove);
    }

    @Override
    public void addPaddingUnSubscribe(int messageId, MqttPendingUnSubscription pendingUnSubscription) {
        this.pendingUnSubscriptions.put(messageId, pendingUnSubscription);
    }

    @Override
    public MqttPendingUnSubscription getPaddingUnSubscribe(int messageId) {
        return this.pendingUnSubscriptions.get(messageId);
    }

    @Override
    public MqttPendingUnSubscription removePaddingUnSubscribe(int messageId) {
        return this.pendingUnSubscriptions.remove(messageId);
    }

    @Override
    public void addPendingPublish(int messageId, MqttPendingPublish pendingPublish) {
        this.pendingPublishData.put(messageId, pendingPublish);
    }

    @Override
    public MqttPendingPublish getPendingPublish(int messageId) {
        return this.pendingPublishData.get(messageId);
    }

    @Override
    public MqttPendingPublish removePendingPublish(int messageId) {
        return this.pendingPublishData.remove(messageId);
    }

    @Override
    public void addPendingQos2Publish(int messageId, MqttPendingQos2Publish pendingQos2Publish) {
        this.pendingQos2PublishData.put(messageId, pendingQos2Publish);
    }

    @Override
    public MqttPendingQos2Publish getPendingQos2Publish(int messageId) {
        return this.pendingQos2PublishData.get(messageId);
    }

    @Override
    public MqttPendingQos2Publish removePendingQos2Publish(int messageId) {
        return this.pendingQos2PublishData.remove(messageId);
    }

    @Override
    public void clean() {
        this.subscriptions.clear();
        this.pendingSubscriptions.clear();
        this.pendingUnSubscriptions.clear();
        this.pendingPublishData.clear();
        this.pendingQos2PublishData.clear();
    }
}

