/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.client;

import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import net.dreamlu.iot.mqtt.codec.ByteBufferAllocator;
import net.dreamlu.iot.mqtt.codec.MqttProperties;
import net.dreamlu.iot.mqtt.codec.MqttVersion;
import net.dreamlu.iot.mqtt.core.client.DefaultMqttClientMessageIdGenerator;
import net.dreamlu.iot.mqtt.core.client.DefaultMqttClientProcessor;
import net.dreamlu.iot.mqtt.core.client.DefaultMqttClientSession;
import net.dreamlu.iot.mqtt.core.client.IMqttClientConnectListener;
import net.dreamlu.iot.mqtt.core.client.IMqttClientMessageIdGenerator;
import net.dreamlu.iot.mqtt.core.client.IMqttClientSession;
import net.dreamlu.iot.mqtt.core.client.MqttClient;
import net.dreamlu.iot.mqtt.core.client.MqttClientAioHandler;
import net.dreamlu.iot.mqtt.core.client.MqttClientAioListener;
import net.dreamlu.iot.mqtt.core.client.MqttWillMessage;
import net.dreamlu.iot.mqtt.core.util.ThreadUtil;
import net.dreamlu.iot.mqtt.core.util.timer.AckService;
import net.dreamlu.iot.mqtt.core.util.timer.DefaultAckService;
import org.tio.client.ReconnConf;
import org.tio.client.TioClient;
import org.tio.client.TioClientConfig;
import org.tio.client.intf.TioClientHandler;
import org.tio.client.intf.TioClientListener;
import org.tio.core.TioConfig;
import org.tio.core.ssl.SslConfig;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public final class MqttClientCreator {
    public static final int DEFAULT_KEEP_ALIVE_SECS = 60;
    private String name = "Mica-Mqtt-Client";
    private String ip = "127.0.0.1";
    private int port = 1883;
    private Integer timeout;
    private int readBufferSize = 8192;
    private int maxBytesInMessage = 0xA00000;
    private int maxClientIdLength = 23;
    private int keepAliveSecs = 60;
    private SslConfig sslConfig;
    private boolean reconnect = true;
    private long reInterval = 5000L;
    private int retryCount = 0;
    private int reSubscribeBatchSize = 20;
    private String clientId;
    private MqttVersion version = MqttVersion.MQTT_3_1_1;
    private String username = null;
    private String password = null;
    private boolean cleanSession = true;
    private Integer sessionExpiryIntervalSecs;
    private MqttWillMessage willMessage;
    private MqttProperties properties;
    private ByteBufferAllocator bufferAllocator = ByteBufferAllocator.HEAP;
    private IMqttClientConnectListener connectListener;
    private IMqttClientSession clientSession;
    private IMqttClientMessageIdGenerator messageIdGenerator;
    private boolean statEnable = false;
    private boolean debug = false;
    private SynThreadPoolExecutor tioExecutor;
    private ThreadPoolExecutor groupExecutor;
    private ThreadPoolExecutor mqttExecutor;
    private AckService ackService;
    private Consumer<TioConfig> tioConfigCustomize;

    public String getName() {
        return this.name;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public int getMaxBytesInMessage() {
        return this.maxBytesInMessage;
    }

    public int getMaxClientIdLength() {
        return this.maxClientIdLength;
    }

    public int getKeepAliveSecs() {
        return this.keepAliveSecs;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public long getReInterval() {
        return this.reInterval;
    }

    public int getReSubscribeBatchSize() {
        return this.reSubscribeBatchSize;
    }

    public String getClientId() {
        return this.clientId;
    }

    public MqttVersion getVersion() {
        return this.version;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public Integer getSessionExpiryIntervalSecs() {
        return this.sessionExpiryIntervalSecs;
    }

    public MqttWillMessage getWillMessage() {
        return this.willMessage;
    }

    public MqttProperties getProperties() {
        return this.properties;
    }

    public ByteBufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    public IMqttClientConnectListener getConnectListener() {
        return this.connectListener;
    }

    public IMqttClientSession getClientSession() {
        return this.clientSession;
    }

    public IMqttClientMessageIdGenerator getMessageIdGenerator() {
        return this.messageIdGenerator;
    }

    public boolean isStatEnable() {
        return this.statEnable;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public SynThreadPoolExecutor getTioExecutor() {
        return this.tioExecutor;
    }

    public ThreadPoolExecutor getGroupExecutor() {
        return this.groupExecutor;
    }

    public ThreadPoolExecutor getMqttExecutor() {
        return this.mqttExecutor;
    }

    public AckService getAckService() {
        return this.ackService;
    }

    public MqttClientCreator name(String name) {
        this.name = name;
        return this;
    }

    public MqttClientCreator ip(String ip) {
        this.ip = ip;
        return this;
    }

    public MqttClientCreator port(int port) {
        this.port = port;
        return this;
    }

    public MqttClientCreator timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public MqttClientCreator readBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    public MqttClientCreator maxBytesInMessage(int maxBytesInMessage) {
        this.maxBytesInMessage = maxBytesInMessage;
        return this;
    }

    public MqttClientCreator maxClientIdLength(int maxClientIdLength) {
        this.maxClientIdLength = maxClientIdLength;
        return this;
    }

    public MqttClientCreator keepAliveSecs(int keepAliveSecs) {
        this.keepAliveSecs = keepAliveSecs;
        return this;
    }

    public MqttClientCreator useSsl() {
        try {
            this.sslConfig = SslConfig.forClient();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public MqttClientCreator sslConfig(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    public MqttClientCreator reconnect(boolean reconnect) {
        this.reconnect = reconnect;
        return this;
    }

    public MqttClientCreator retryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    public MqttClientCreator reInterval(long reInterval) {
        this.reInterval = reInterval;
        return this;
    }

    public MqttClientCreator reSubscribeBatchSize(int reSubscribeBatchSize) {
        this.reSubscribeBatchSize = reSubscribeBatchSize;
        return this;
    }

    public MqttClientCreator clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public MqttClientCreator version(MqttVersion version) {
        this.version = version;
        return this;
    }

    public MqttClientCreator username(String username) {
        this.username = username;
        return this;
    }

    public MqttClientCreator password(String password) {
        this.password = password;
        return this;
    }

    public MqttClientCreator cleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
        return this;
    }

    public MqttClientCreator sessionExpiryIntervalSecs(Integer sessionExpiryIntervalSecs) {
        this.sessionExpiryIntervalSecs = sessionExpiryIntervalSecs;
        return this;
    }

    public MqttClientCreator willMessage(MqttWillMessage willMessage) {
        this.willMessage = willMessage;
        return this;
    }

    public MqttClientCreator willMessage(Consumer<MqttWillMessage.Builder> consumer) {
        MqttWillMessage.Builder builder = MqttWillMessage.builder();
        consumer.accept(builder);
        return this.willMessage(builder.build());
    }

    public MqttClientCreator properties(MqttProperties properties) {
        this.properties = properties;
        return this;
    }

    public MqttClientCreator bufferAllocator(ByteBufferAllocator allocator) {
        this.bufferAllocator = allocator;
        return this;
    }

    public MqttClientCreator connectListener(IMqttClientConnectListener connectListener) {
        this.connectListener = connectListener;
        return this;
    }

    public MqttClientCreator clientSession(IMqttClientSession clientSession) {
        this.clientSession = clientSession;
        return this;
    }

    public MqttClientCreator messageIdGenerator(IMqttClientMessageIdGenerator messageIdGenerator) {
        this.messageIdGenerator = messageIdGenerator;
        return this;
    }

    public MqttClientCreator statEnable() {
        return this.statEnable(true);
    }

    public MqttClientCreator statEnable(boolean enable) {
        this.statEnable = enable;
        return this;
    }

    public MqttClientCreator debug() {
        this.debug = true;
        return this;
    }

    public MqttClientCreator tioExecutor(SynThreadPoolExecutor tioExecutor) {
        this.tioExecutor = tioExecutor;
        return this;
    }

    public MqttClientCreator groupExecutor(ThreadPoolExecutor groupExecutor) {
        this.groupExecutor = groupExecutor;
        return this;
    }

    public MqttClientCreator mqttExecutor(ThreadPoolExecutor mqttExecutor) {
        this.mqttExecutor = mqttExecutor;
        return this;
    }

    public MqttClientCreator ackService(AckService ackService) {
        this.ackService = ackService;
        return this;
    }

    public MqttClientCreator ackService(long tickMs, int wheelSize) {
        return this.ackService(new DefaultAckService(tickMs, wheelSize));
    }

    public MqttClientCreator tioConfigCustomize(Consumer<TioConfig> tioConfigCustomize) {
        this.tioConfigCustomize = tioConfigCustomize;
        return this;
    }

    private MqttClient build() {
        if (StrUtil.isBlank((CharSequence)this.clientId)) {
            this.clientId("MICA-MQTT-" + Long.toString(System.nanoTime(), 36));
        }
        if (this.clientSession == null) {
            this.clientSession = new DefaultMqttClientSession();
        }
        if (this.messageIdGenerator == null) {
            this.messageIdGenerator = new DefaultMqttClientMessageIdGenerator();
        }
        if (this.tioExecutor == null) {
            this.tioExecutor = ThreadUtil.getTioExecutor(3);
        }
        if (this.groupExecutor == null) {
            this.groupExecutor = ThreadUtil.getGroupExecutor(2);
        }
        if (this.mqttExecutor == null) {
            this.mqttExecutor = ThreadUtil.getMqttExecutor(2);
        }
        if (this.ackService == null) {
            this.ackService = new DefaultAckService();
        }
        DefaultMqttClientProcessor processor = new DefaultMqttClientProcessor(this);
        MqttClientAioHandler clientAioHandler = new MqttClientAioHandler(this, processor);
        MqttClientAioListener clientAioListener = new MqttClientAioListener(this);
        ReconnConf reconnConf = null;
        if (this.reconnect) {
            reconnConf = new ReconnConf(this.reInterval, this.retryCount);
        }
        TioClientConfig tioConfig = new TioClientConfig((TioClientHandler)clientAioHandler, (TioClientListener)clientAioListener, reconnConf, this.tioExecutor, this.groupExecutor);
        tioConfig.setName(this.name);
        tioConfig.setHeartbeatTimeout(0L);
        if (this.readBufferSize > 0) {
            tioConfig.setReadBufferSize(this.readBufferSize);
        }
        tioConfig.setSslConfig(this.sslConfig);
        tioConfig.statOn = this.statEnable;
        if (this.debug) {
            tioConfig.debug = true;
        }
        if (this.tioConfigCustomize != null) {
            this.tioConfigCustomize.accept((TioConfig)tioConfig);
        }
        try {
            TioClient tioClient = new TioClient(tioConfig);
            return new MqttClient(tioClient, this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Mica mqtt client start fail.", e);
        }
    }

    public MqttClient connect() {
        return this.build().start(false);
    }

    public MqttClient connectSync() {
        return this.build().start(true);
    }
}

