/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.server.cluster;

import net.dreamlu.iot.mqtt.core.server.MqttServer;
import net.dreamlu.iot.mqtt.core.server.enums.MessageType;
import net.dreamlu.iot.mqtt.core.server.model.Message;
import net.dreamlu.iot.mqtt.core.server.session.IMqttSessionManager;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;

public class MqttClusterMessageListener {
    private final String nodeName;
    private final IMqttSessionManager sessionManager;
    private final MqttServer mqttServer;

    public MqttClusterMessageListener(MqttServer mqttServer) {
        this.nodeName = mqttServer.getServerCreator().getNodeName();
        this.sessionManager = mqttServer.getServerCreator().getSessionManager();
        this.mqttServer = mqttServer;
    }

    public void onMessage(Message message) {
        String clientId;
        ChannelContext context;
        MessageType messageType = message.getMessageType();
        String topic = message.getTopic();
        if (MessageType.CONNECT == messageType) {
            String node = message.getNode();
            if (this.nodeName.equals(node)) {
                return;
            }
            String clientId2 = message.getClientId();
            ChannelContext context2 = Tio.getByBsId((TioConfig)this.mqttServer.getServerConfig(), (String)clientId2);
            if (context2 != null) {
                Tio.remove((ChannelContext)context2, (String)("clientId:[" + clientId2 + "] now bind on mqtt node:" + node));
            }
        } else if (MessageType.SUBSCRIBE == messageType) {
            String formClientId = message.getFromClientId();
            ChannelContext context3 = this.mqttServer.getChannelContext(formClientId);
            if (context3 != null) {
                this.sessionManager.addSubscribe(topic, formClientId, message.getQos());
            }
        } else if (MessageType.UNSUBSCRIBE == messageType) {
            String formClientId = message.getFromClientId();
            ChannelContext context4 = this.mqttServer.getChannelContext(formClientId);
            if (context4 != null) {
                this.sessionManager.removeSubscribe(topic, formClientId);
            }
        } else if (MessageType.UP_STREAM == messageType) {
            this.mqttServer.sendToClient(topic, message);
        } else if (MessageType.DOWN_STREAM == messageType) {
            this.mqttServer.sendToClient(topic, message);
        } else if (MessageType.DISCONNECT == messageType && (context = this.mqttServer.getChannelContext(clientId = message.getClientId())) != null) {
            Tio.remove((ChannelContext)context, (String)("Mqtt server delete clients:" + clientId));
        }
    }
}

