/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.server.http.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import net.dreamlu.iot.mqtt.core.server.MqttServerCreator;
import net.dreamlu.iot.mqtt.core.server.dispatcher.IMqttMessageDispatcher;
import net.dreamlu.iot.mqtt.core.server.enums.MessageType;
import net.dreamlu.iot.mqtt.core.server.http.api.code.ResultCode;
import net.dreamlu.iot.mqtt.core.server.http.api.form.BaseForm;
import net.dreamlu.iot.mqtt.core.server.http.api.form.PublishForm;
import net.dreamlu.iot.mqtt.core.server.http.api.form.SubscribeForm;
import net.dreamlu.iot.mqtt.core.server.http.api.result.Result;
import net.dreamlu.iot.mqtt.core.server.http.handler.MqttHttpRoutes;
import net.dreamlu.iot.mqtt.core.server.model.Message;
import net.dreamlu.iot.mqtt.core.server.model.Subscribe;
import net.dreamlu.iot.mqtt.core.server.session.IMqttSessionManager;
import net.dreamlu.iot.mqtt.core.util.PayloadEncode;
import net.dreamlu.iot.mqtt.core.util.TopicUtil;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.Method;
import org.tio.utils.hutool.StrUtil;

public class MqttHttpApi {
    private final IMqttMessageDispatcher messageDispatcher;
    private final IMqttSessionManager sessionManager;

    public MqttHttpApi(MqttServerCreator serverCreator) {
        this.messageDispatcher = serverCreator.getMessageDispatcher();
        this.sessionManager = serverCreator.getSessionManager();
    }

    public HttpResponse endpoints(HttpRequest request) {
        return Result.ok(request, MqttHttpRoutes.getRouts().keySet());
    }

    public HttpResponse publish(HttpRequest request) {
        PublishForm form = MqttHttpApi.readForm(request, requestBody -> (PublishForm)JSON.parseObject((byte[])requestBody, PublishForm.class, (Feature[])new Feature[0]));
        if (form == null) {
            return Result.fail(request, ResultCode.E101);
        }
        HttpResponse validResponse = MqttHttpApi.validForm(false, form, request);
        if (validResponse != null) {
            return validResponse;
        }
        this.sendPublish(form);
        return Result.ok();
    }

    public HttpResponse publishBatch(HttpRequest request) {
        List formList = MqttHttpApi.readForm(request, requestBody -> {
            String jsonBody = new String((byte[])requestBody, StandardCharsets.UTF_8);
            return JSON.parseArray((String)jsonBody, PublishForm.class);
        });
        if (formList == null || formList.isEmpty()) {
            return Result.fail(request, ResultCode.E101);
        }
        for (PublishForm form : formList) {
            HttpResponse validResponse = MqttHttpApi.validForm(false, form, request);
            if (validResponse == null) continue;
            return validResponse;
        }
        for (PublishForm form : formList) {
            this.sendPublish(form);
        }
        return Result.ok();
    }

    private void sendPublish(PublishForm form) {
        String payload = form.getPayload();
        Message message = new Message();
        message.setMessageType(MessageType.DOWN_STREAM);
        message.setClientId(form.getClientId());
        message.setTopic(form.getTopic());
        message.setQos(form.getQos());
        message.setRetain(form.isRetain());
        if (StrUtil.isNotBlank((CharSequence)payload)) {
            message.setPayload(ByteBuffer.wrap(PayloadEncode.decode(payload, form.getEncoding())));
        }
        this.messageDispatcher.send(message);
    }

    public HttpResponse subscribe(HttpRequest request) {
        SubscribeForm form = MqttHttpApi.readForm(request, requestBody -> (SubscribeForm)JSON.parseObject((byte[])requestBody, SubscribeForm.class, (Feature[])new Feature[0]));
        if (form == null) {
            return Result.fail(request, ResultCode.E101);
        }
        HttpResponse validResponse = MqttHttpApi.validForm(true, form, request);
        if (validResponse != null) {
            return validResponse;
        }
        int qos = form.getQos();
        if (qos < 0 || qos > 2) {
            return Result.fail(request, ResultCode.E101);
        }
        this.sendSubOrUnSubscribe(form);
        return Result.ok();
    }

    public HttpResponse subscribeBatch(HttpRequest request) {
        List formList = MqttHttpApi.readForm(request, requestBody -> {
            String jsonBody = new String((byte[])requestBody, StandardCharsets.UTF_8);
            return JSON.parseArray((String)jsonBody, SubscribeForm.class);
        });
        if (formList == null || formList.isEmpty()) {
            return Result.fail(request, ResultCode.E101);
        }
        for (SubscribeForm form : formList) {
            HttpResponse validResponse = MqttHttpApi.validForm(true, form, request);
            if (validResponse != null) {
                return validResponse;
            }
            int qos = form.getQos();
            if (qos >= 0 && qos <= 2) continue;
            return Result.fail(request, ResultCode.E101);
        }
        for (SubscribeForm form : formList) {
            this.sendSubOrUnSubscribe(form);
        }
        return Result.ok();
    }

    public HttpResponse unsubscribe(HttpRequest request) {
        BaseForm form = MqttHttpApi.readForm(request, requestBody -> (BaseForm)JSON.parseObject((byte[])requestBody, BaseForm.class, (Feature[])new Feature[0]));
        if (form == null) {
            return Result.fail(request, ResultCode.E101);
        }
        HttpResponse validResponse = MqttHttpApi.validForm(true, form, request);
        if (validResponse != null) {
            return validResponse;
        }
        this.sendSubOrUnSubscribe(form);
        return Result.ok();
    }

    public HttpResponse unsubscribeBatch(HttpRequest request) {
        List formList = MqttHttpApi.readForm(request, requestBody -> {
            String jsonBody = new String((byte[])requestBody, StandardCharsets.UTF_8);
            return JSON.parseArray((String)jsonBody, BaseForm.class);
        });
        if (formList == null || formList.isEmpty()) {
            return Result.fail(request, ResultCode.E101);
        }
        for (BaseForm form : formList) {
            HttpResponse validResponse = MqttHttpApi.validForm(true, form, request);
            if (validResponse == null) continue;
            return validResponse;
        }
        for (BaseForm form : formList) {
            this.sendSubOrUnSubscribe(form);
        }
        return Result.ok();
    }

    public HttpResponse deleteClients(HttpRequest request) {
        String clientId = request.getParam("clientId");
        if (StrUtil.isBlank((CharSequence)clientId)) {
            return Result.fail(request, ResultCode.E101);
        }
        Message message = new Message();
        message.setClientId(clientId);
        message.setMessageType(MessageType.DISCONNECT);
        this.messageDispatcher.send(message);
        return Result.ok();
    }

    public HttpResponse getClientSubscriptions(HttpRequest request) {
        String clientId = request.getParam("clientId");
        if (StrUtil.isBlank((CharSequence)clientId)) {
            return Result.fail(request, ResultCode.E101);
        }
        List<Subscribe> subscribeList = this.sessionManager.getSubscriptions(clientId);
        return Result.ok(new HttpResponse(request), subscribeList);
    }

    private void sendSubOrUnSubscribe(BaseForm form) {
        Message message = new Message();
        message.setFromClientId(form.getClientId());
        message.setTopic(form.getTopic());
        if (form instanceof SubscribeForm) {
            message.setQos(((SubscribeForm)form).getQos());
            message.setMessageType(MessageType.SUBSCRIBE);
        } else {
            message.setMessageType(MessageType.UNSUBSCRIBE);
        }
        this.messageDispatcher.send(message);
    }

    private static <T> T readForm(HttpRequest request, Function<byte[], T> function) {
        byte[] requestBody = request.getBody();
        if (requestBody == null) {
            return null;
        }
        return function.apply(requestBody);
    }

    private static HttpResponse validForm(boolean isTopicFilter, BaseForm form, HttpRequest request) {
        String clientId = form.getClientId();
        if (StrUtil.isBlank((CharSequence)clientId)) {
            return Result.fail(request, ResultCode.E101);
        }
        String topic = form.getTopic();
        if (StrUtil.isBlank((CharSequence)topic)) {
            return Result.fail(request, ResultCode.E101);
        }
        try {
            if (isTopicFilter) {
                TopicUtil.validateTopicFilter(topic);
            } else {
                TopicUtil.validateTopicName(topic);
            }
        }
        catch (IllegalArgumentException exception) {
            return Result.fail(request, ResultCode.E102);
        }
        return null;
    }

    public void register() {
        MqttHttpRoutes.register(Method.GET, "/api/v1/endpoints", this::endpoints);
        MqttHttpRoutes.register(Method.POST, "/api/v1/mqtt/publish", this::publish);
        MqttHttpRoutes.register(Method.POST, "/api/v1/mqtt/publish/batch", this::publishBatch);
        MqttHttpRoutes.register(Method.POST, "/api/v1/mqtt/subscribe", this::subscribe);
        MqttHttpRoutes.register(Method.POST, "/api/v1/mqtt/subscribe/batch", this::subscribeBatch);
        MqttHttpRoutes.register(Method.POST, "/api/v1/mqtt/unsubscribe", this::unsubscribe);
        MqttHttpRoutes.register(Method.POST, "/api/v1/mqtt/unsubscribe/batch", this::unsubscribeBatch);
        MqttHttpRoutes.register(Method.POST, "/api/v1/clients/delete", this::deleteClients);
        MqttHttpRoutes.register(Method.GET, "/api/v1/client/subscriptions", this::getClientSubscriptions);
    }
}

