/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.server.http.api.auth;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import net.dreamlu.iot.mqtt.core.server.http.api.code.ResultCode;
import net.dreamlu.iot.mqtt.core.server.http.api.result.Result;
import net.dreamlu.iot.mqtt.core.server.http.handler.HttpFilter;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.utils.hutool.StrUtil;

public class BasicAuthFilter
implements HttpFilter {
    public static final HeaderName WWW_AUTHENTICATE = HeaderName.from((String)"WWW-Authenticate");
    public static final HeaderValue BASIC_REALM = HeaderValue.from((String)"Basic realm=\"Mica mqtt realm\"");
    public static final String BASIC_AUTH_HEADER_NAME = "authorization";
    public static final String AUTHORIZATION_PREFIX = "Basic ";
    private final String token;

    public BasicAuthFilter(String username, String password) {
        this.token = BasicAuthFilter.getBasicToken(username, password);
    }

    @Override
    public boolean filter(HttpRequest request) throws Exception {
        String authorization = request.getHeader(BASIC_AUTH_HEADER_NAME);
        if (StrUtil.isBlank((CharSequence)authorization)) {
            return false;
        }
        int length = AUTHORIZATION_PREFIX.length();
        if (length >= authorization.length()) {
            return false;
        }
        return this.token.equals(authorization.substring(length));
    }

    @Override
    public HttpResponse response(HttpRequest request) {
        HttpResponse response = new HttpResponse(request);
        response.addHeader(WWW_AUTHENTICATE, BASIC_REALM);
        Result.fail(response, ResultCode.E103);
        return response;
    }

    private static String getBasicToken(String username, String password) {
        Objects.requireNonNull(username, "Basic auth username is null");
        Objects.requireNonNull(password, "Basic auth password is null");
        byte[] tokenBytes = (username + ':' + password).getBytes(StandardCharsets.UTF_8);
        return Base64.getEncoder().encodeToString(tokenBytes);
    }
}

